# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components.configs.basesearch import notifications_template, workflow_template
from sandbox.projects.release_machine.components import configs
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri


class RemoteStorageCfg(configs.ReferenceBranchedConfig):
    name = "remote_storage"
    display_name = "Web Remote Storage"
    responsible = "okats"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "SEARCH-RELEASERS"
        testenv_db_owners = ["andreikkaa"]
        trunk_db = "ws-remote-storage-trunk"
        branch_db_template = "ws-remote-storage-{testenv_db_num}"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementBuildBranched(
                        task_name="BUILD_REMOTE_STORAGE",
                        ctx={
                            "notify_if_failed": "SEARCH-RELEASERS",
                        },
                        out={"REMOTE_STORAGE_EXECUTABLE": 90},
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_part.append(
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        input_key="component_resources",
                                        dict_key="remote_storage",
                                        resource_name="REMOTE_STORAGE_EXECUTABLE",
                                    ),
                                ),
                            ),
                        ),
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                    )
                )

                return release_part

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="remote_storage",
                    data=ri.SandboxResourceData("REMOTE_STORAGE_EXECUTABLE", ttl=100),
                    deploy_infos=[ri.single_nanny_service("{}_jupiter_remote_storage".format(location)) for location in rm_const.MAIN_LOCATIONS],
                ),
            ]

    class Notify(configs.ReferenceBranchedConfig.Notify):
        notifications = notifications_template

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["base_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)
            invite_link = "https://t.me/joinchat/CaUODkKTwtMdwenQIkLLKQ"

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "andreikkaa"
            queue = "BASEREL"
            dev_queue = "SEARCH"
            summary_template = "Remote storage acceptance {}"
            use_task_author_as_assignee = True
            workflow = workflow_template
            add_commiters_as_followers = False

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "jandekspoisk/kachestvopoiska/remotestorage/releases/"
        ya_make_targets = [
            "search/base_search/daemons/remote_storage",
        ]
        review_groups = [
            "base",
        ]
