from sandbox.projects.release_machine.components.configs.upper_search.web import SearchIntegrationTestsBundle
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.upper_search.base.web import TestReportFunctionalOpt, TestReportFunctionalInvertedOpt
from sandbox.projects.release_machine.components.configs.report.report import search_integration_env, SearchIntergationTestBundle  # noqa UnusedImport


class ReportTestsBundle():
    @staticmethod
    def get_bundle(entry_cube, beta_cube, soy_pool):
        """
        Returns list of report tests

        :type entry_cube: Cube
        :param entry_cube:
            Entry cube for tests dependencies

        :type beta_cube: Cube
        :param beta_cube:
            Beta cube for tests dependencies

        :type soy_pool: str
        :param soy_pool:
            The name of the soy_pool
        """

        report_functional_tests = [
            TestReportFunctionalOpt(
                entry_cube=entry_cube,
                component_name="report",
            ),
            TestReportFunctionalInvertedOpt(
                entry_cube=entry_cube,
                component_name="report",
            ),
        ]

        return SearchIntegrationTestsBundle.get_bundle(beta_cube, soy_pool) + report_functional_tests
