# -*- coding: utf-8 -*-

from functools import partial
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
from sandbox.projects.release_machine.components.config_core import notifications as rm_notifications
from sandbox.projects.common import constants as sandbox_constants
import sandbox.projects.release_machine.components.config_core.statistics_page as statistics_page
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


def search_integration_env(x, tld, soy_pool="search_integration_tests", soy_type="scraper"):
    return (
        "BETA_HOST={beta_url}.{tld} "
        "{soy_mode} {soy_map_op_type} {oauth_token} "
        "{soy_pool} "
    ).format(
        beta_url=x,
        tld=tld,
        soy_mode="SOY_MODE=1",
        soy_map_op_type="SOY_MAP_OP_TYPE={}".format(soy_type),
        oauth_token="OAUTH_TOKEN='$(vault:value:SEARCH-RELEASERS:common_release_token)'",
        soy_pool="SOY_POOL={}".format(soy_pool),
    )


def search_integration_env_tld(x, params):
    return search_integration_env(x, "ru")


class SearchIntergationTestBundle():
    @staticmethod
    def get_bundle(job_name_parameter_beta="beta", soy_pool="search_integration_tests"):
        tests = [
            jg_test.JobGraphElementTrunkMetaTestCodeInBranch(
                task_name="SEARCH_INTEGRATION_TESTS_WITH_RETRIES",
                job_params={
                    "job_name_parameter": "SEARCH_INTEGRATION_TEST",
                    "frequency": (jg_utils.TestFrequency.LAZY, None),
                    "apiargs": {
                        "kill_timeout": 3 * 3600,
                    },
                },
                job_arrows=(
                    jg_job_triggers.JobTriggerGenerateBeta(
                        job_name_parameter=job_name_parameter_beta,
                        parent_job_data=(
                            jg_job_data.ParentDataOutput(
                                input_key="env_vars",
                                output_key="new_beta_url",
                                # Freevars are not permitted in case RMINCIDENTS-449
                                transform=partial(lambda x, params, soy_pool: search_integration_env(x, "ru", soy_pool),
                                                  soy_pool=soy_pool),
                            )
                        )
                    )
                ),
                ctx={
                    "targets": "search/integration_tests",
                    sandbox_constants.TESTS_REQUESTED: True,
                    sandbox_constants.DISABLE_TEST_TIMEOUT: True,
                    sandbox_constants.YA_MAKE_EXTRA_PARAMETERS: ["--test-filter=mark:not soy_http", "--test-stderr"],
                    "retry_task": 3,
                    "threshold_failed_tests": 100,
                    "retry_all_tests": True
                },
            ),
            jg_test.JobGraphElementTrunkMetaTestCodeInBranch(
                task_name="SEARCH_INTEGRATION_TESTS_WITH_RETRIES",
                job_params={
                    "job_name_parameter": "SEARCH_INTEGRATION_TEST_SOY_HTTP",
                    "frequency": (jg_utils.TestFrequency.LAZY, None),
                    "apiargs": {
                        "kill_timeout": 3 * 3600,
                    },
                },
                job_arrows=(
                    jg_job_triggers.JobTriggerGenerateBeta(
                        job_name_parameter=job_name_parameter_beta,
                        parent_job_data=(
                            jg_job_data.ParentDataOutput(
                                input_key="env_vars",
                                output_key="new_beta_url",
                                # Freevars are not permitted in case RMINCIDENTS-449
                                transform=partial(lambda x, params, soy_pool: search_integration_env(x, "ru", soy_pool, soy_type="http"),
                                                  soy_pool=soy_pool),
                            )
                        )
                    )
                ),
                ctx={
                    "targets": "search/integration_tests",
                    sandbox_constants.TESTS_REQUESTED: True,
                    sandbox_constants.DISABLE_TEST_TIMEOUT: True,
                    sandbox_constants.YA_MAKE_EXTRA_PARAMETERS: ["--test-filter=mark:soy_http", "--test-stderr"],
                    "retry_task": 3,
                    "threshold_failed_tests": 100,
                    "retry_all_tests": True
                },
            ),
            jg_test.JobGraphElementTrunkMetaTestCodeInBranch(
                job_params={
                    "job_name_parameter": "SEARCH_INTEGRATION_TEST_STYLE",
                    "frequency": (jg_utils.TestFrequency.LAZY, None),
                    "apiargs": {
                        "kill_timeout": 3 * 3600,
                    },
                },
                job_arrows=(
                    jg_job_triggers.JobTriggerGenerateBeta(
                        job_name_parameter=job_name_parameter_beta,
                        parent_job_data=(
                            jg_job_data.ParentDataOutput(
                                input_key="env_vars",
                                output_key="new_beta_url",
                                # Freevars are not permitted in case RMINCIDENTS-449
                                transform=partial(lambda x, params, soy_pool: search_integration_env(x, "ru", soy_pool),
                                                  soy_pool=soy_pool),
                            )
                        )
                    )
                ),
                ctx={
                    "targets": "search/integration_tests",
                    sandbox_constants.TESTS_REQUESTED: True,
                    sandbox_constants.DISABLE_TEST_TIMEOUT: True,
                    sandbox_constants.YA_MAKE_EXTRA_PARAMETERS: ["--style", "--test-stderr"]
                },
            )
        ]
        return tests


class ReportCfg(configs.ReferenceBranchedConfig):
    component_group = "reference_component_metricsed"
    name = "report"
    responsible = configs.Responsible(login="elshiko", abc=configs.Abc(component_id=1609, role_id=None, schedule_slug="srcsetup_mapping_report_releases"))

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_db = "ws-report-trunk"
        trunk_task_owner = "REPORT_CORE"
        branch_db_template = "ws-report-{testenv_db_num}"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            default_yamake_task = 'KOSHER_YA_MAKE'

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_REPORT_CORE",
                        ctx={
                            "project": "WEB",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="report_arcadia_url",
                                        output_key=sandbox_constants.ARCADIA_URL_KEY,
                                    )
                                )
                            )
                        ),
                        out={"REPORT_CORE_PACKAGE": 30},
                    )
                )
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_CONFIGS_WITH_PVA",
                        build_item="INSTANCECTL_CONF",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="arcadia_url",
                                        output_key=sandbox_constants.ARCADIA_URL_KEY,
                                    )
                                )
                            ),
                            jg_arrows.GlobalResourceData(
                                input_key="pva",
                                resource_name="APPHOST_PVA",
                            )
                        ),
                        ctx={
                            "config_types": "\n".join([
                                "REPORT_PRODUCTION_INSTANCECTL_CONF",
                                "REPORT_YAPPY_INSTANCECTL_CONF",
                                "REPORT_PUSHCLIENT_PRODUCTION_CONF",
                                "REPORT_PUSHCLIENT_YAPPY_CONF",
                            ]),
                        },
                        out={
                            "REPORT_PRODUCTION_INSTANCECTL_CONF": 90,
                            "REPORT_YAPPY_INSTANCECTL_CONF": 90,
                            "REPORT_PUSHCLIENT_PRODUCTION_CONF": 90,
                            "REPORT_PUSHCLIENT_YAPPY_CONF": 90,
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementYappyBetaGeneratorBranched(
                        beta_conf_type="beta",
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "report_core_package",
                                        "REPORT_CORE_PACKAGE",
                                    ),
                                ),
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="INSTANCECTL_CONF",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "production_instancectl_conf_res_id",
                                        "REPORT_PRODUCTION_INSTANCECTL_CONF",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "yappy_instancectl_conf_res_id",
                                        "REPORT_YAPPY_INSTANCECTL_CONF",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "pushclient_production_conf_res_id",
                                        "REPORT_PUSHCLIENT_PRODUCTION_CONF",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "pushclient_yappy_conf_res_id",
                                        "REPORT_PUSHCLIENT_YAPPY_CONF",
                                    ),
                                ),
                            ),
                        ),
                        ctx={
                            "update_beta_mode": "APPEND",
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementE2ETest(
                        task_name="SANDBOX_CI_WEB4_EXPERIMENTS_RELEASE_RUNNER",
                        ctx={
                            "task_retries": 5,
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="beta",
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="hermionee2e_base_url",
                                        output_key="new_beta_url",
                                        transform=lambda x, params: "https://{}.ru".format(x),
                                    ),
                                ),
                            ),
                        )
                    )
                )

                for t in SearchIntergationTestBundle.get_bundle(soy_pool="report_web_priemka"):
                    branch_part.append(t)

                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="SITESEARCH_INTEGRATION_TEST",
                        job_params={
                            "job_name_parameter": "SITESEARCH_INTEGRATION_TEST",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                            "apiargs": {
                                "requirements": {
                                    "platform": "linux_ubuntu_16.04_xenial",
                                },
                            },
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="beta",
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="serp_host",
                                        output_key="new_beta_url",
                                        transform=lambda x, params: "{}.ru".format(x),
                                    )
                                )
                            ),
                        ),
                        ctx={
                            "description": "SitesearchTests for report release",
                            "git_reference": "dev"
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementLaunchMetrics(
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="beta",
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="checked_beta",
                                        output_key="new_beta_url",
                                    )
                                )
                            ),
                        ),
                        ctx={
                            "sample_beta": "hamster",
                            "scraper_over_yt_pool": "report_web_priemka",
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestXMLSearch(
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="beta",
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="beta_url",
                                        output_key="new_beta_url",
                                        transform=lambda x, params: "https://{}.ru".format(x),
                                    )
                                )
                            ),
                        ),
                        ctx={
                            "search_subtypes": "web",
                        }
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedScheduled(
                        job_params={
                            "frequency": (jg_utils.TestFrequency.RUN_IF_DELAY_N_MINUTES, 1440),
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerE2ETest(),
                            jg_job_triggers.JobTriggerLaunchMetrics(),
                            jg_job_triggers.JobTriggerTestXMLSearch(),
                            jg_job_triggers.JobTriggerMetaTest(
                                job_name_parameter="SEARCH_INTEGRATION_TEST",
                            ),
                            jg_job_triggers.JobTriggerMetaTest(
                                job_name_parameter="SEARCH_INTEGRATION_TEST_SOY_HTTP",
                            ),
                            jg_job_triggers.JobTriggerMetaTest(
                                job_name_parameter="SEARCH_INTEGRATION_TEST_STYLE",
                            ),
                        )
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_part.append(
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "report_core_package",
                                        "REPORT_CORE_PACKAGE",
                                    )
                                )
                            )
                        )
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                    )
                )
                return release_part

        class JobPatch(configs.ReferenceBranchedConfig.Testenv.JobPatch):
            """TestEnv Job Patch"""

            @property
            def change_frequency(self):
                tests = super(self.__class__, self).change_frequency
                tests.update({
                    "_BUILD_RELEASE_REPORT_INSTANCECTL_CONF": rm_const.TestFrequencies.EACH_REV_TEST,
                })
                return tests

    class ReleaseViewer(configs.ReferenceConfig.ReleaseViewer):
        """Release viewer configuration"""
        kpi_alert = 3
        kpi_alert_skip_weekends = True
        statistics_page_charts = statistics_page.DEFAULT + [statistics_page.PredefinedCharts.TIMESPECTRE_METRICS]

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        resources_info = [
            configs.ReleasedResourceInfo(
                name="report",
                resource_type="REPORT_CORE_PACKAGE",
                resource_name="report_core_package",
                deploy=[(rm_const.ReleaseStatus.stable, "production_report_vla_web_yp")],
            ),
            configs.ReleasedResourceInfo(
                name="production_instancectl_conf",
                resource_type="REPORT_PRODUCTION_INSTANCECTL_CONF",
                resource_name="production_instancectl_conf_res_id",
            ),
            configs.ReleasedResourceInfo(
                name="yappy_instancectl_conf",
                resource_type="REPORT_YAPPY_INSTANCECTL_CONF",
                resource_name="yappy_instancectl_conf_res_id",
            ),
            configs.ReleasedResourceInfo(
                name="pushclient_production_conf",
                resource_type="REPORT_PUSHCLIENT_PRODUCTION_CONF",
                resource_name="pushclient_production_conf_res_id",
            ),
            configs.ReleasedResourceInfo(
                name="pushclient_yappy_conf",
                resource_type="REPORT_PUSHCLIENT_YAPPY_CONF",
                resource_name="pushclient_yappy_conf_res_id",
            ),
        ]
        allow_robots_to_release_stable = True
        allow_old_releases = True
        release_followers_permanent = [
            "elshiko",
        ]

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        notifications = [
            rm_notifications.Notification(
                event_type="MergeCommit",
                chat_name="report_from_rm_const",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_SUCCESS_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="NewBranch",
                chat_name="report_from_rm_const",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_SUCCESS_AND_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="NewTag",
                chat_name="report_from_rm_const",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_SUCCESS_AND_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="KpiAlert",
                chat_name="report_from_rm_const",
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="TicketHistory",
                chat_name="report_from_rm_const",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.STARTREK_TICKET_CREATED_CONDITIONS,
                    join_strategy="OR",
                ),
                message_template_file="notifications/ticket_created.html",
            ),
            rm_notifications.Notification(
                event_type="ReleaseCreated",
                chat_name="report_from_rm_const",
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_created_oldschool.html",
            ),
            rm_notifications.Notification(
                event_type="ReleaseDeployed",
                chat_name="report_from_rm_const",
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_deployed_oldschool.html",
            ),
        ]

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            """Telegram notifications configuration"""
            chats = ["report"]
            config = configs.RmTelegramNotifyConfig(chats=chats)
            invite_link = "https://t.me/joinchat/CaUODkYSN2MyE5jE9xgJzg"

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = configs.Responsible(login="elshiko", abc=configs.Abc(component_id=1609, role_id=None, schedule_slug="srcsetup_mapping_report_releases"))
            queue = "REPORTREL"
            dev_queue = "WEBREPORT"
            summary_template = u"Приемка web report {}"
            components = u"web_report"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "elshiko",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 4
            nanny_reports = False

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "serp/report/releases/web-report/"
        dirs = [
            "arcadia/web/report",
            "arcadia/search/garden/runtime_tests",
        ]

    class MetricsCfg(configs.ReferenceBranchedConfig.MetricsCfg):
        """Metrics configuration"""

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        tag_prefix = "r"
        branch_prefix = "r"
        branch_folder_template = "{branch_prefix}{branch_num}"
        tag_folder_template = "{tag_prefix}{branch_num}/1.{tag_num}"
        tag_folder_pattern = r"r([0-9]+)/1\.([0-9]+)"
        allow_autobranches = True

    class Yappy(yappy_cfg.YappyBaseCfg):
        betas = {
            "beta": yappy_cfg.YappyBetaCfg(
                beta_name="report-web-1",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyBetaPatch(
                        patch_file="report-report-web-1",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                local_path="report_core.tar", param_name="report_core_package"
                            ),
                            yappy_cfg.YappyParametrizedResource(
                                local_path="instancectl.conf", param_name="yappy_instancectl_conf_res_id"
                            ),
                            yappy_cfg.YappyParametrizedResource(
                                local_path="push-client.conf.tmpl", param_name="pushclient_yappy_conf_res_id"
                            ),
                        ],
                        parent_service="hamster_report_vla_web_yp",
                    ),
                ],
            ),
        }
