from sandbox.projects.common import constants as sandbox_constants
from sandbox.projects.release_machine.components.config_core.jg.cube.base import CubeInput
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.upper_search.base import SearchReleasesBuildTestCube
from sandbox.projects.release_machine.components.configs.upper_search.web import SearchIntegrationTestsBundle
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.upper_search.base.web import TestRA2Tests
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.upper_search.request_init import GetBegemotResponsesTest, CheckBegemotResponsesTest


class RequestInitTestsBundle():
    @staticmethod
    def get_bundle(targets, sanitizers, entry_cube, build_cube, request_plan, beta_cube, soy_pool):
        """
        Returns list of request_init component tests

        :type targets: List[str]
        :param targets:
            List of arcadia paths for ya_make tests

        :type sanitizers: List[str]
        :param sanitizers:
            List of sanitizers for ya_make tests

        :type entry_cube: Cube
        :param entry_cube:
            The name of the build stage entry cube for ya_make tests dependencies

        :type build_cube: Cube
        :param build_cube:
            The name of the build cube for request_init tests dependencies

        :type request_plan: int
        :param request_plan:
            Input param for GET_BEGEMOT_RESPONSES task

        :type beta_cube: Cube
        :param beta_cube:
            The name of the beta cube this cube depends on

        :type soy_pool: str
        :param soy_pool:
            The name of the soy_pool

        :return: List[TestE2ETestsCube, TestSearchIntegrationTestsCube, TestSearchIntegrationSoyHttpTestsCube,
            LaunchMetricsCube, TestRA2TestsCube, TestSiteSearchTestsCube, GetBegemotResponsesTest, CheckBegemotResponsesTest,
            *SanitizersTests*]
        """

        get_responses_test_cube = GetBegemotResponsesTest(build_cube, request_plan)

        return SearchIntegrationTestsBundle.get_bundle(beta_cube, soy_pool) + \
            [
                TestRA2Tests(beta_cube),
                get_responses_test_cube,
                CheckBegemotResponsesTest(get_responses_test_cube, build_cube, request_plan),
            ] + \
            [
                SearchReleasesBuildTestCube(
                    name="ya_make_{}_sanitizer_test".format(sanitizer) if sanitizer else "ya_make_diff_test",
                    needs=[entry_cube],
                    input=CubeInput(**{
                        "targets": ";".join(targets),
                        sandbox_constants.SANITIZE: sanitizer,
                    }),
                ) for sanitizer in sanitizers
            ]
