# -*- coding: utf-8 -*-
import os
import sandbox.projects.release_machine.components.config_core.statistics_page as statistics_page
from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.components.config_core.jg.graph import base as graph_base
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow
from sandbox.projects.release_machine.components.config_core.jg.cube import base as jg_cube
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import release as release_cubes
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.configs.request_init import RequestInitTestsBundle
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.upper_search.base import IceFlamePatched


BUILD_RESOURCES = (
    {
        "name": "begemot",
        "type": "BEGEMOT_REQUEST_INIT_EXECUTABLE",
    },
    {
        "name": "fast_build_config.json",
        "type": "BEGEMOT_FAST_BUILD_CONFIG_REQUEST_INIT",
    },
    {
        "name": "evlogdump",
        "type": "BEGEMOT_EVLOGDUMP",
    },
    {
        "name": "bstr",
        "type": "BEGEMOT_BSTR",
    },
    {
        "name": "bstr_caller",
        "type": "BEGEMOT_BSTR_CALLER",
    },
    {
        "name": "eventlog_uploader",
        "type": "BEGEMOT_EVLOG_UPLOADER",
    },
    {
        "name": "fast_build_data_downloader",
        "type": "BEGEMOT_FAST_BUILD_DOWNLOADER",
    },
    {
        "name": "fast_data_callback",
        "type": "BEGEMOT_FAST_DATA_CALLBACK",
    },
    {
        "name": "instancectl.conf",
        "type": "BEGEMOT_INSTANCECTL_CONF",
    },
    {
        "name": "worker.cfg",
        "type": "BEGEMOT_CONFIG",
    },
    {
        "name": "args",
        "type": "BEGEMOT_ARGUMENTS_PARSER",
    },
)

REQUESTS_PLAN_RESOURSE_ID = 1370873029

PRESTABLE_WEB = [
    "prestable_request_init_web_sas",
]
PROD_WEB = [
    "production_request_init_web_sas",
    "production_request_init_web_man",
    "production_request_init_web_vla",
]
HAMSTER_WEB = [
    "hamster_request_init_web_sas",
    "hamster_request_init_web_man",
    "hamster_request_init_web_vla",
]
WEB_SERVICES = PRESTABLE_WEB + PROD_WEB + HAMSTER_WEB
SHARED_SERVICES = [
    "production_request_init_shared_sas",
    "production_request_init_shared_man",
    "production_request_init_shared_vla"
]
UNIPROXY_SERVICES = [
    "production_request_init_uniproxy_sas",
    "production_request_init_uniproxy_man",
    "production_request_init_uniproxy_vla",
    "hamster_request_init_uniproxy_sas",
    "hamster_request_init_uniproxy_man",
    "hamster_request_init_uniproxy_vla",
]

PARENT_SERVICE = "hamster_request_init_web_sas"

YA_MAKE_TESTS = {
    "targets": [
        "web/daemons/flags_raw_provider/tests/shoot_tests",
        "web/daemons/flags_raw_provider/tests/ut",
        "web/library/condition_evaluation/ut",
        "web/library/flags_merge/ut",
        "web/report/data/flags/tests",
        "web/src_setup/lib/setup/common/request/ut",
    ],
    "sanitizers": ["address", "thread", "memory", "leak", "undefined"],
}


class BegemotRequestInitCfg(cfg.ReferenceCIConfig):
    name = "request_init"
    display_name = "RequestInit Web CI"
    responsible = cfg.Responsible(
        abc=cfg.Abc(service_name="request_init_web"),
        login="alex-ersh"
    )

    # metrics launch
    component_group = "reference_component_metricsed"

    class CI(cfg.ReferenceCIConfig.CI):
        a_yaml_dir = "search/daemons/begemot/request_init"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "REPORT_CORE"

        ya_make_abs_paths_glob = [
            os.path.join("search/daemons/begemot/request_init", "**"),
        ]

    class JG(basic_build_presets.SingleBuildGeneralJGCfg):
        # JG params
        add_beta_generator = "web"
        build_task = "projects/upper_search/request_init/release_task"  # Default parameters are in the yaml task file

        # configuring auto-deploy
        release_manually = False

        @jg_flow.release_flow(
            stages=basic_build_presets.JOINED_BUILD_RELEASE_FLOW_STAGES,
        )
        def release(self):
            graph = super(self.__class__, self).release(self)

            main_stage_entry_cube = graph.get("main_graph_entry")
            build_cube = graph.get("build")
            beta_cube = graph.get("generate_beta__request_init__web")
            release_entry_cube = graph.get("release_stage_entry")

            #  tests init
            tests = RequestInitTestsBundle.get_bundle(
                targets=YA_MAKE_TESTS["targets"],
                sanitizers=YA_MAKE_TESTS["sanitizers"],
                entry_cube=main_stage_entry_cube,
                build_cube=build_cube,
                request_plan=REQUESTS_PLAN_RESOURSE_ID,
                beta_cube=beta_cube,
                soy_pool="report_web_priemka",
            )

            # add cubes to graph
            for test in tests:
                if not hasattr(test, "NOT_REQUIRED_BY_RELEASE"):
                    release_entry_cube.add_requirement(test)
                graph.add(test)

            return graph

        def _check_releasable_item_is_suitable(self, ri):
            return hasattr(ri.data, "resource_type") and ri.data.resource_type != "SCHEDULED_RM_RELEASE_DATA"

        # activating build cube
        def _get_build_cube(self, graph):
            return jg_cube.Cube(
                name=self.build_cube_name,
                task=self.build_task,
                input=jg_cube.CubeInput(
                    all_resources=False,
                    begemot_resources="BegemotConfig RequestInitExecutable Bstr RequestInit NannyConfigs",
                    build_type="release",
                    use_aapi_fuse=True,
                    definition_flags="-DRESERVE_ADDRESS_SPACE=128",
                ),
                needs=[
                    graph.get(dummy_cubes.RMMainGraphEntry.NAME),
                ],
            )

        # activate Morty release
        def _get_release_cubes_for_deploy_system(self, deploy_system, where, releasable_items, graph, build):
            return [
                release_cubes.ScheduleRelease(
                    name="release_{}_{}".format(where, deploy_system),
                    component_name=self.component_name,
                    where_to_release=where,
                    flows=["deploy"],
                    warden_component_name="request_init",
                    warden_parent_component_name="web",
                    deploy_system=deploy_system,
                    schedule_mode="create_and_schedule",
                    input=jg_cube.CubeInput(
                        component_resources={
                            ri.name: build.output.resources[ri.data.resource_type].first().id
                            for ri in releasable_items
                        },
                    ),
                    manual=self.release_manually,
                ),
            ]

        @jg_flow.register_flow(title="Run IceFlame")
        def run_iceflame(self):
            return graph_base.Graph([IceFlamePatched(BegemotRequestInitCfg.name, "begemot", PARENT_SERVICE, "request_init.conf")])

    class Releases(cfg.ReferenceCIConfig.Releases):
        release_followers_permanent = [
            "alex-ersh",
            "elshiko",
        ]
        allow_robots_to_release_stable = True

        @property
        def releasable_items(self):
            deploy_infos = [
                ri.NannyDeployInfo(
                    [
                        ri.DeployService(i, tags=["prod"]) for i in PROD_WEB
                    ] + [
                        ri.DeployService(i, tags=["hamster"]) for i in HAMSTER_WEB
                    ] + [
                        ri.DeployService(i, tags=["prestable"]) for i in PRESTABLE_WEB
                    ] + [
                        ri.DeployService(i, tags=["shared"]) for i in SHARED_SERVICES
                    ] + [
                        ri.DeployService(i, tags=["uniproxy"]) for i in UNIPROXY_SERVICES
                    ]
                )
            ]

            items = [
                ri.ReleasableItem(
                    resource["name"],
                    ri.SandboxResourceData(resource["type"]),
                    deploy_infos=deploy_infos
                ) for resource in BUILD_RESOURCES
            ] + [
                ri.DynamicReleasableItem(
                    name="scheduled_bundle",
                    data=ri.SandboxResourceData("SCHEDULED_RM_RELEASE_DATA"),
                    deploy_infos=[ri.NannyDeployInfo()],
                ),
            ]

            return items

    class Yappy(cfg.ReferenceCIConfig.Yappy):
        betas = {
            "web": yappy_cfg.YappyTemplateCfg(
                template_name="request-init-web",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="request-init-web",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                param_name=res["name"],
                                local_path=res["name"],
                            ) for res in BUILD_RESOURCES
                        ],
                        parent_service=PARENT_SERVICE,
                    )
                ])
        }
        working_betas_limit = 2

    class Notify(cfg.ReferenceCIConfig.Notify):
        class Startrek(cfg.ReferenceCIConfig.Notify.Startrek):
            assignee = "alex-ersh"
            queue = "INITREL"
            summary_template = u"Приемка Begemot RequestInit {}"
            add_commiters_as_followers = True
            deadline = 7

            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }

            use_task_author_as_assignee = False
            write_merges_in_table = True

    class ChangelogCfg(cfg.ReferenceCIConfig.ChangelogCfg):
        ya_make_targets = [
            "arcadia/search/daemons/begemot/request_init",
        ]

        use_previous_branch_as_baseline = True

    class SvnCfg(cfg.ReferenceCIConfig.SvnCfg):
        allow_autobranches = False

    class MetricsCfg(cfg.ReferenceCIConfig.MetricsCfg):
        limit_s = None

    class ReleaseViewer(cfg.ReferenceCIConfig.ReleaseViewer):
        statistics_page_charts = statistics_page.DEFAULT + [statistics_page.PredefinedCharts.TIMESPECTRE_METRICS]
