# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.job_graph.presets import ci_presets
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class RequestSamplerCfg(configs.ReferenceCIConfig):
    name = "request_sampler"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="releasemachine"),
        login="mvel",
    )

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="request_sampler_resource_id",
                    data=ri.SandboxResourceData("REQUEST_SAMPLER_EXECUTABLE", ttl=30),
                )
            ]
        allow_robots_to_release_stable = True
        release_followers_permanent = [
            "elshiko",
            "mvel",
        ]

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "search/tools/request_sampler"

        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "SEARCH-RELEASERS"

        ya_make_abs_paths_glob = [
            "search/tools/request_sampler/**",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

        class JobGraph(configs.ReferenceCIConfig.CI.JobGraph):

            _preset = ci_presets.SingleBuildCiPreset(
                build_task_name="BUILD_SEARCH",
                build_ctx={"build_request_sampler": True},
                deploy_system=rm_const.DeploySystem.kosher_sandbox_release.name,
                stages=[jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable)],
            )

    class Notify(configs.ReferenceCIConfig.Notify):
        use_startrek = False

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = ""
        observed_paths = [
            "arcadia/search/tools/request_sampler",
        ]

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        start_version = 4  # moved to the CI since 3rd branch
