# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.presets as jg_presets
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class ResourceCacheControllerCfg(configs.ReferenceBranchedConfig):
    """
        Resource Cache Controller for Y.Deploy.
        Draft description on wiki: https://wiki.yandex-team.ru/drug/rcc/
    """

    name = "resource_cache_controller"
    responsible = "amich"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "DRUG-RELEASERS"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            _preset = jg_presets.SinglePackagePreset(
                build_apiargs={"requirements": {"disk_space": (10 << 30)}},
                package_names="infra/resource_cache_controller/deploy/package/package.json",
                deploy_system=rm_const.DeploySystem.nanny.name,
                use_compression=False,
                stages=[jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable)],
            )

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_test.JobGraphElementMetaTestBranched(
                        job_params={
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        ctx={
                            "targets": "infra/resource_cache_controller",
                        }
                    )
                )
                return branch_part

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="resource_cache_controller_package",
                    data=ri.SandboxResourceData("RESOURCE_CACHE_CONTROLLER_PACKAGE", ttl=30),
                    deploy_infos=[ri.single_nanny_service("vla_yp_resource_cache_ctl")],
                )
            ]

        release_followers_permanent = [
            "amich",
            "dkochetov",
        ]

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            """Telegram notifications configuration"""
            chats = []
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "amich"
            queue = "RCCTLREL"
            dev_queue = "DEPLOY"
            summary_template = u"Приемка resource_cache_controller {}"
            workflow = {}
            followers = [
                "amich",
                "dkochetov",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "infra/resourcecachecontroller/releases/"
        dirs = [
            "arcadia/infra/resource_cache_controller",
            "arcadia/infra/libs/controller",
            "arcadia/yp/cpp/yp",
            "arcadia/yp/yp_proto/yp/client/api/proto/resource_cache.proto",
        ]
