import os

from sandbox.projects.release_machine.components import configs

from sandbox.projects.release_machine.components.config_core.jg.cube.lib import build as build_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import internal as internal_cubes

from sandbox.projects.release_machine.core import const as rm_const


PATHS = [
    "sandbox/projects/release_machine/components/configs/",
    "sandbox/projects/release_machine/components/config_core/",
    "sandbox/projects/release_machine/components/custom/",
    "sandbox/projects/release_machine/core/",
    "release_machine/config_converter/",
]


class RmConfigsCfg(configs.ReferenceCIConfig):

    name = "rm_configs"
    display_name = "ReleaseMachine Configs"

    responsible = configs.Responsible(
        abc=configs.Abc(service_name="releasemachine"),
        login="ilyaturuntaev",
    )

    class Releases(configs.ReferenceCIConfig.Releases):
        resources_info = []

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "sandbox/projects/release_machine/components/configs/"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "RELEASE_MACHINE"

        ya_make_abs_paths_glob = [os.path.join(path, "**") for path in PATHS]

    class JG(configs.jg_base.JGCfg):

        def _get_build_prepare_ci_environment_cube(self, ttl=1):
            return build_cubes.DeployBinaryTask(
                target="sandbox/projects/release_machine/tasks/PrepareCiEnvironment/bin",
                target_task_type="PREPARE_CI_ENVIRONMENT",
                name="build",
                input=configs.jg_cube.CubeInput(
                    release_ttl=ttl,
                ),
            )

        def _get_run_prepare_ci_environment_cube(self, build):
            return internal_cubes.PrepareCiEnvironment(
                component_name=self.root_cfg.name,
                input=configs.jg_cube.CubeInput(
                    debug_mode=True,
                    create_review=False,
                    component_name_forced_ignore=rm_const.COMPONENT_AYAML_AUTOGEN_BLACKLIST,
                    binary_executor_release_type="custom",
                ),
                needs=[build],
                attributes={
                    "requirements": {
                        "sandbox": {
                            "tasks_resource": build.output.resources["SANDBOX_TASKS_BINARY"].first().id,
                        },
                    },
                },
            )

        @configs.jg_flow.precommit_check_flow(
            title="ReleaseMachine Configs Precommit Check",
        )
        def rm_config_precommit(self):

            entry = dummy_cubes.Dummy("rm_configs_precommit_entry")

            build_prepare_ci_environment = self._get_build_prepare_ci_environment_cube()
            build_prepare_ci_environment.add_requirement(entry)

            run_prepare_ci_environment = self._get_run_prepare_ci_environment_cube(build_prepare_ci_environment)

            return configs.jg_graph.Graph([
                entry,
                build_prepare_ci_environment,
                run_prepare_ci_environment,
            ])

    class Notify(configs.ReferenceCIConfig.Notify):
        use_startrek = False

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = None
        observed_paths = list(PATHS)
