# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri

from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets


class RmTaskletBundleCfg(configs.ReferenceCIConfig):
    name = "rm_tasklet_bundle"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="releasemachine"),
        login="ilyaturuntaev",
    )

    class JG(basic_build_presets.TaskletBuildPreset):
        release_ticket = "RMREL-226"

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "release_machine/tasklets/bundle"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "RELEASE_MACHINE"

        ya_make_abs_paths_glob = [
            "release_machine/tasklets/bundle/**",
            "sandbox/projects/release_machine/components/configs/**",
            "sandbox/projects/release_machine/components/config_core/**",
        ]

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="rm_tasklet_bundle",
                    data=ri.SandboxResourceData("SANDBOX_TASKS_BINARY", ttl=14),
                    build_data=ri.BuildData(
                        target="release_machine/tasklets/bundle",
                        artifact="release_machine/tasklets/bundle/rm_tasklets_bundle",
                    ),
                    deploy_infos=[
                        ri.CiTaskletRegistryDeployInfo(
                            registry_paths=[
                                "projects/release_machine/create_arc_tag",
                                "projects/release_machine/format_rm_changelog",
                                "projects/release_machine/get_or_create_st_ticket",
                                "projects/release_machine/link_feature_tickets_from_changelog",
                                "projects/release_machine/configure_ab_experiments_tests",
                                "projects/release_machine/commit_tasklet_version",
                            ],
                        ),
                    ]
                ),
            ]

    class Notify(configs.ReferenceCIConfig.Notify):
        use_startrek = False
