# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
from sandbox.projects.release_machine.core import releasable_items as ri


DEPLOY_INFOS = [
    ri.single_nanny_service(service_name, stage="stable")
    for service_name in [
        "market_rpslimiter_balancer",
        "pdb_rpslimiter",
        "rpslimiter",
        "rpslimiter-serval",
        "rpslimiter-testing",
        "rps-storage",
        "translate_rpslimiter",
    ]
]


class RpsLimiterCfg(configs.ReferenceCIConfig):
    name = "rpslimiter"
    responsible = configs.Responsible(
        "denis28",
        abc=configs.Abc(service_name="rpslimiter"),
    )

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="rpslimiter",
                    data=ri.SandboxResourceData("RPS_LIMITER_BINARY"),
                    deploy_infos=DEPLOY_INFOS
                ),
                ri.ReleasableItem(
                    name="agent",
                    data=ri.SandboxResourceData("RPS_LIMITER_AGENT_BINARY"),
                    deploy_infos=DEPLOY_INFOS
                ),
                ri.ReleasableItem(
                    name="model",
                    data=ri.SandboxResourceData("RPS_LIMITER_MODEL_BINARY"),
                    deploy_infos=DEPLOY_INFOS
                ),
                ri.ReleasableItem(
                    name="balancer",
                    data=ri.SandboxResourceData("RPS_LIMITER_BALANCER_EXECUTABLE"),
                    deploy_infos=DEPLOY_INFOS
                ),
            ]

        allow_robots_to_release_stable = True

    class CI(configs.ReferenceCIConfig.CI):
        """CI configuration"""
        a_yaml_dir = "search/rpslimiter"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "SEARCH-RELEASERS"

    class JG(basic_build_presets.SingleBuildYaMakeTemplateJGCfg):
        build_task = "projects/rpslimiter/build_rpslimiter"

    class Notify(configs.ReferenceCIConfig.Notify):
        """Notifications configuration"""

        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "denis28"
            queue = "RPSREL"
            summary_template = u"Приемка RpsLimiter {}"
            workflow = {}

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = ""
        dirs = [
            "arcadia/search/rpslimiter",
        ]

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        """Branches configuration"""
        start_version = 42
