from sandbox.projects.release_machine.components.config_core.jg import cube as jg_cube
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import build as cube_build

import uuid
import random


random.seed(1)


class AbstractResource:
    def id(self):
        raise NotImplementedError

    def type(self):
        raise NotImplementedError

    def cube(self, name, needs):
        raise NotImplementedError


class BuildableResource(AbstractResource):
    def __init__(self, binary_path, resource_type=None, identifier=None):
        self.binary_name = binary_path.rsplit('/', 1)[1]
        self.build_root = binary_path.rsplit('/', 1)[0]
        self._id = str(
            uuid.UUID(int=random.getrandbits(128), version=4),
        ) if identifier is None else identifier
        self._type = (
            'ARCADIA_PROJECT_BINARY'
            if resource_type is None else resource_type
        )

    @property
    def id(self):
        return self._id

    @property
    def type(self):
        return self._type

    def cube(self, name=None, needs=None):
        needs = [] if needs is None else needs
        name = self.binary_name if name is None else name
        name = name.replace('-', '_')

        return cube_build.KosherYaMake(
            name='build_{}'.format(name),
            targets=self.build_root,
            artifacts='/'.join((self.build_root, self.binary_name)),
            resource_types=self.type,
            input=jg_cube.CubeInput(
                strip_binaries=True,
                result_attrs=dict(
                    id=self.id,
                ),
                result_single_file=True,
                test=False,
            ),
            needs=needs,
        )
