# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.core import const as rm_const

import sandbox.projects.release_machine.components.job_graph.presets as jg_presets
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class RtUserSessionsCfg(cfg.ReferenceBranchedConfig):
    name = "rt_user_sessions"
    display_name = "rUSt"
    responsible = cfg.Responsible(abc=cfg.Abc(component_id=33128, role_id=8), login="mmatrosova")

    class MergesCfg(cfg.ReferenceBranchedConfig.MergesCfg):
        number_last_branches_to_merge = 1

    class Testenv(cfg.ReferenceBranchedConfig.Testenv):
        """
        TestEnv configuration settings
        """

        trunk_task_owner = "USERSESSIONSTOOLS"

        # Read our documentation for better understanding https://wiki.yandex-team.ru/ReleaseMachine/JobGraph/
        class JobGraph(cfg.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _prerelease(self):
                """
                Prerelease part of job graph for Testenv with arrows and dependencies
                :return: list with jobs
                """
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementWiki(),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrekWiki(
                        job_params={
                            "next_revision_custom_schedule": jg_utils.CustomSchedule(
                                time_interval_list=[(6, 9)],
                                weekday_list=[0, 2],
                                seconds_from_last_run_commit=3600,
                                seconds_from_last_run_start_time=3600,
                                last_run_finished=False,
                                once_a_day=True,
                            )
                        }
                    ),
                ]

            _preset = jg_presets.SingleBuildPreset(
                build_task_name="USER_SESSIONS_RT_RELEASER",
                deploy_system=rm_const.DeploySystem.sandbox.name,
                stages=[
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable),
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.prestable, jg_utils.CheckEachCommit()),
                ],
                release_ctx={'additional_release_parameters': {'release_tag': ''}}
            )

    class Notify(cfg.ReferenceBranchedConfig.Notify):
        class Startrek(cfg.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""

            assignee = cfg.Responsible(
                abc=cfg.Abc(component_id=33128, role_id=8, schedule_slug='rtyt'), login="mmatrosova"
            )
            queue = "USRTREL"
            dev_queue = "ZBL"
            summary_template = u"[r{}] RUST release"
            workflow = {}
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

            @property
            def banned_people(self):
                return super(self.__class__, self).banned_people | {"pechatnov"}

    class ChangelogCfg(cfg.ReferenceBranchedConfig.ChangelogCfg):
        """
        Changelog configuration
        https://wiki.yandex-team.ru/releasemachine/changelogs/
        """

        dirs = [
            'quality/user_sessions/rt',
            'ads/bsyeti/big_rt',
            'statbox/qb3',
            'quality/user_sessions/createlib/qb3',
        ]
        wiki_page = "logs/usersessions/rtyt/release/releaseshistory/"

    class Releases(cfg.ReferenceBranchedConfig.Releases):
        # Releasable items
        # Contains information for production state monitoring.

        @property
        def releasable_items(self):
            stages = [
                ri.YaDeployInfo(ri.DeployService('user-sessions-rt'), rm_const.ReleaseStatus.stable),
                ri.YaDeployInfo(ri.DeployService('user-sessions-rt-hamster'), rm_const.ReleaseStatus.stable),
                ri.YaDeployInfo(ri.DeployService('user-sessions-rt-prestable'), rm_const.ReleaseStatus.prestable),
            ]
            return [
                ri.ReleasableItem(
                    name='rust-stages', data=ri.SandboxResourceData('US_RT_STAGE_CONFIG'), deploy_infos=stages,
                ),
            ]

        deploy_system = rm_const.DeploySystem.sandbox
        allow_robots_to_release_stable = True
        allow_old_releases = True

    class SvnCfg(cfg.ReferenceBranchedConfig.SvnCfg):
        max_active_branches = 10
        merge_to_old_branches = True

    class MetricsCfg(cfg.ReferenceBranchedConfig.MetricsCfg):
        """ Metrics configuration """

        limit_s = 14 * 60 * 60  # Limit for SERPs downloads (in seconds)
        default_launch_id = ""  # Default launch ID

    class Yappy(cfg.ReferenceBranchedConfig.Yappy):
        working_betas_limit = 3
        wait_for_deploy_time_sec = 4 * 60 * 60
        betas = {}
