# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.common import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


BUILD_ITEMS = ['MEDIATOR', 'MEDIATOR_BALANCER']


class RtcMediatorCfg(configs.ReferenceBranchedConfig):
    name = "rtc_mediator"
    display_name = "RTC Mediator"
    responsible = configs.Responsible(abc=configs.Abc(component_id=4050, role_id=16), login="ivaxer")

    class Releases(configs.ReferenceBranchedConfig.Releases):
        allow_old_releases = True
        allow_robots_to_release_stable = True
        wait_for_deploy_time_sec = 20 * 60
        responsible = configs.Responsible(abc=configs.Abc(component_id=4050, role_id=413), login="ivaxer")

        resources_info = [
            configs.ReleasedResourceInfo(
                name=component,
                resource_type=component,
                resource_name=component.lower(),
                deploy=deploy_targets,
                build_ctx_key="arcadia_url")
            for component, deploy_targets in [
                (
                    'MEDIATOR_BUNDLE',
                    [
                        (rm_const.ReleaseStatus.stable, "mediator-man"),
                        (rm_const.ReleaseStatus.prestable, "man-alpha-mediator-yp"),
                        (rm_const.ReleaseStatus.testing, "man-testing-mediator-yp"),
                    ]
                ),
                (
                    'MEDIATOR_CONFING_BUNDLE',
                    [
                        (rm_const.ReleaseStatus.stable, "mediator-man"),
                    ]
                ),
                (
                    'MEDIATOR_ALPHA_CONFING_BUNDLE',
                    [
                        (rm_const.ReleaseStatus.prestable, "man-alpha-mediator-yp"),
                    ]
                ),
                (
                    'MEDIATOR_TESTING_CONFING_BUNDLE',
                    [
                        (rm_const.ReleaseStatus.testing, "man-testing-mediator-yp"),
                    ]
                ),
                (
                    'MEDIATOR_BALANCER_BUNDLE',
                    [
                        (rm_const.ReleaseStatus.stable, "man-mediator-balancer"),
                        (rm_const.ReleaseStatus.prestable, "vla-alpha-mediator-balancer"),
                        (rm_const.ReleaseStatus.testing, "vla-testing-mediator-balancer"),
                        (rm_const.ReleaseStatus.testing, "vla-loadtest-mediator-yp"),
                    ]
                ),
                (
                    'MEDIATOR_BALANCER_CONFING_BUNDLE',
                    [
                        (rm_const.ReleaseStatus.stable, "man-mediator-balancer"),
                    ]
                ),
                (
                    'MEDIATOR_BALANCER_ALPHA_CONFING_BUNDLE',
                    [
                        (rm_const.ReleaseStatus.prestable, "vla-alpha-mediator-balancer"),
                    ]
                ),
                (
                    'MEDIATOR_BALANCER_TESTING_CONFING_BUNDLE',
                    [
                        (rm_const.ReleaseStatus.testing, "vla-testing-mediator-balancer"),
                    ]
                ),
                (
                    'MEDIATOR_BALANCER_LOADTEST_CONFING_BUNDLE',
                    [
                        (rm_const.ReleaseStatus.testing, "vla-loadtest-mediator-yp"),
                    ]
                )
            ]
        ]

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_prefix = "rtc_mediator"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_db = "rtc-mediator-trunk"
        trunk_task_owner = "RTC"

        testenv_db_owners = [
            "ivaxer",
            "dsamuylov",
            "ivanov-d-s",
            "yak-dmitriy",
        ]

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementWiki(),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrekWiki(
                        next_revision_custom_schedule=jg_utils.CustomSchedule(
                            time_interval_list=[(10, 15)],
                            weekday_list=[0],  # monday
                            seconds_from_last_run_start_time=14 * 24 * 60 * 60,  # every two weeks.
                            last_run_finished=True,
                            once_a_day=True
                        )
                    ),
                ]

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                for build_item in BUILD_ITEMS:
                    branch_part.append(
                        jg_build.JobGraphElementYaMakeBuildBranched(
                            task_name="BUILD_RTC_{}".format(build_item),
                            build_item=build_item,
                            job_arrows=(
                                jg_job_triggers.JobTriggerNewTag(
                                    parent_job_data=(
                                        jg_job_data.ParentDataOutput(
                                            input_key="arcadia_url",
                                            output_key=sandbox_constants.ARCADIA_URL_KEY,
                                        )
                                    )
                                )
                            ),
                            ctx={
                                "build_type": "relwithdebinfo",
                                "sym_dump": "61581470",
                            },
                            out={
                                "{}_BUNDLE".format(build_item): 90,
                            },
                        )
                    )
                    branch_part.append(
                        jg_build.JobGraphElementYaMakeBuildBranched(
                            task_name="BUILD_RTC_{}_CONFIG".format(build_item),
                            build_item="{}_CONFIG".format(build_item),
                            job_arrows=(
                                jg_job_triggers.JobTriggerNewTag(
                                    parent_job_data=(
                                        jg_job_data.ParentDataOutput(
                                            input_key="arcadia_url",
                                            output_key=sandbox_constants.ARCADIA_URL_KEY,
                                        )
                                    )
                                )
                            ),
                            out={
                                "{}_CONFING_BUNDLE".format(build_item): 90,
                                "{}_ALPHA_CONFING_BUNDLE".format(build_item): 90,
                                "{}_TESTING_CONFING_BUNDLE".format(build_item): 90,
                                "{}_LOADTEST_CONFING_BUNDLE".format(build_item): 90,
                            },
                        )
                    )
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="YA_MAKE_2",
                        build_item="ARCADIA_TESTS",
                        job_params={
                            "apiargs": {
                                "requirements": {
                                    "ram": 24 * 1024 ** 3,  # 24 Gb
                                    "disk_space": 80 * (1024 ** 3),  # 80 Gb
                                },
                            },
                        },
                        ctx={
                            "targets": "rtc/mediator;rtc/balancer",
                            "clear_build": False,
                            "test": True,
                            "report_tests_only": True,
                            "disable_test_timeout": True,
                            "cache_test_results": False,
                            "tests_retries": 2,
                        },
                    )
                )

                deploy_triggers = []
                for build_item in BUILD_ITEMS:
                    deploy_triggers.append(
                        jg_job_triggers.JobTriggerBuild(
                            job_name_parameter="{}".format(build_item),
                            parent_job_data=(
                                jg_job_data.ParentDataId(
                                    input_key="{}_id".format(build_item.lower()),
                                ),
                            )
                        )
                    )
                    deploy_triggers.append(
                        jg_job_triggers.JobTriggerBuild(
                            job_name_parameter="{}_CONFIG".format(build_item),
                            parent_job_data=(
                                jg_job_data.ParentDataId(
                                    input_key="{}_config_id".format(build_item.lower()),
                                ),
                            )
                        )
                    )

                release_type_to_dashboard = {
                    rm_const.ReleaseStatus.testing: "testing-seq",
                    rm_const.ReleaseStatus.prestable: "alpha-seq",
                    rm_const.ReleaseStatus.stable: "prod-seq",
                }

                for release_type in [
                    rm_const.ReleaseStatus.testing,
                    rm_const.ReleaseStatus.prestable,
                    rm_const.ReleaseStatus.stable,
                ]:
                    branch_part.append(
                        jg_test.JobGraphElementTestBranchCommon(
                            task_name="DEPLOY_NANNY_DASHBOARD_DEV",
                            job_params={
                                "job_name_parameter": "DEPLOY_{}".format(release_type.upper()),
                            },
                            job_arrows=(
                                jg_job_triggers.JobTriggerRelease(
                                    job_name_parameter=release_type,
                                ),
                                jg_arrows.ParentsData(
                                    input_key="deployment_task_id",
                                    triggers=deploy_triggers,
                                    transform=lambda **kwargs: ",".join(map(str, kwargs.values()))
                                )
                            ),
                            ctx={
                                "deployment_nanny_dashboard_name": "mediator",
                                "deployment_nanny_dashboard_recipe": release_type_to_dashboard[release_type],
                                "deployment_release_status": release_type,
                                "deployment_nanny_bool_wait": True,
                                "services_skip_without_release_ticket": True,
                                "services_from_recipe": True,
                                "vault_name": "nanny_oauth_token",
                                "vault_owner": "RTC",
                                "wait_deployment": "120",
                            },
                        )
                    )

                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                for release_stage in [
                    rm_const.ReleaseStatus.stable,
                    rm_const.ReleaseStatus.testing,
                    rm_const.ReleaseStatus.prestable,
                ]:
                    triggers = []
                    for build_item in BUILD_ITEMS:
                        triggers.append(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter=build_item,
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "{}_bundle".format(build_item.lower()),
                                        "{}_BUNDLE".format(build_item),
                                    )
                                )
                            )
                        )
                        triggers.append(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="{}_CONFIG".format(build_item),
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "{}_confing_bundle".format(build_item.lower()),
                                        "{}_CONFING_BUNDLE".format(build_item),
                                    )
                                )
                            )
                        )
                    triggers.append(
                        jg_job_triggers.JobTriggerBuild(
                            job_name_parameter="ARCADIA_TESTS",
                        )
                    )

                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            release_to=release_stage,
                            job_arrows=triggers,
                        )
                    )
                    release_part.append(
                        jg_release.JobGraphElementActionReleaseBranched(
                            release_to=release_stage,
                            job_params={
                                "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                            } if release_stage == rm_const.ReleaseStatus.testing else {},
                            job_arrows=(
                                jg_job_triggers.JobTriggerTestBranchCommon(
                                    job_name_parameter="DEPLOY_{}".format(release_stage.upper()),
                                ),
                            ),
                        )
                    )
                return release_part

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            queue = "RTC"
            summary_template = u"RTC Mediator release {}"
            assignee = "robot-rtc-reis"
            followers = configs.PeopleGroups(
                abc_services=[configs.Abc(component_id=4050, role_id=16)],
                staff_groups=None,
                logins=None,
            )
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            close_linked_tickets = True

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        dirs = [
            "arcadia/rtc/balancer",
            "arcadia/rtc/mediator",
            "arcadia/rtc/configs/mediator",
            "arcadia/rtc/configs/mediator-balancer",
        ]
        wiki_page = "rtc/mediator/releases/"
