# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.common import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


BUILD_ITEMS = ['SIPGW', 'JANUSAPI', 'SIPGW_BALANCER']


class RtcSipgwCfg(configs.ReferenceBranchedConfig):
    name = "rtc_sipgw"
    display_name = "RTC Sipgw"
    responsible = configs.Responsible(abc=configs.Abc(component_id=4050, role_id=16), login="ivaxer")

    class Releases(configs.ReferenceBranchedConfig.Releases):
        allow_old_releases = True
        allow_robots_to_release_stable = True
        wait_for_deploy_time_sec = 20 * 60
        responsible = configs.Responsible(abc=configs.Abc(component_id=4050, role_id=413), login="ivaxer")

        resources_info = [
            configs.ReleasedResourceInfo(
                name=component,
                resource_type=component,
                resource_name=component.lower(),
                deploy=deploy_targets,
                build_ctx_key="arcadia_url")
            for component, deploy_targets in [
                (
                    'SIPGW_BUNDLE',
                    [
                        (rm_const.ReleaseStatus.stable, "man-sipgw-yp"),
                        (rm_const.ReleaseStatus.prestable, "man-alpha-sipgw-yp"),
                    ]
                ),
                (
                    'SIPGW_CONFIG_BUNDLE',
                    [
                        (rm_const.ReleaseStatus.stable, "man-sipgw-yp"),
                    ]
                ),
                (
                    'SIPGW_ALPHA_CONFIG_BUNDLE',
                    [
                        (rm_const.ReleaseStatus.prestable, "man-alpha-sipgw-yp"),
                    ]
                ),
                (
                    'SIPGW_LOOP_CONF',
                    None
                ),
                (
                    'JANUSAPI_BUNDLE',
                    [
                        (rm_const.ReleaseStatus.stable, "man-sipgw-relay"),
                        (rm_const.ReleaseStatus.prestable, "man-alpha-sipgw-relay"),
                    ]
                ),
                (
                    'JANUSAPI_CONFIG_BUNDLE',
                    [
                        (rm_const.ReleaseStatus.stable, "man-sipgw-relay"),
                    ]
                ),
                (
                    'JANUSAPI_ALPHA_CONFIG_BUNDLE',
                    [
                        (rm_const.ReleaseStatus.prestable, "man-alpha-sipgw-relay"),
                    ]
                ),
                (
                    'JANUSAPI_LOOP_CONF',
                    None
                ),
                (
                    'SIPGW_BALANCER_BUNDLE',
                    [
                        (rm_const.ReleaseStatus.stable, "man-sipgw-balancer"),
                        (rm_const.ReleaseStatus.prestable, "man-alpha-sipgw-balancer"),
                    ]
                ),
                (
                    'SIPGW_BALANCER_CONFIG_BUNDLE',
                    [
                        (rm_const.ReleaseStatus.stable, "man-sipgw-balancer"),
                    ]
                ),
                (
                    'SIPGW_BALANCER_ALPHA_CONFIG_BUNDLE',
                    [
                        (rm_const.ReleaseStatus.prestable, "man-alpha-sipgw-balancer"),
                    ]
                ),
                (
                    'SIPGW_BALANCER_LOOP_CONF',
                    None
                )
            ]
        ]

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_prefix = "rtc_sipgw"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_db = "rtc-sipgw-trunk"
        trunk_task_owner = "RTC"

        testenv_db_owners = [
            "ivaxer",
        ]

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementWiki(),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrekWiki(
                        next_revision_custom_schedule=jg_utils.CustomSchedule(
                            time_interval_list=[(10, 15)],
                            weekday_list=[0],  # monday
                            seconds_from_last_run_start_time=14 * 24 * 60 * 60,  # every two weeks.
                            last_run_finished=True,
                            once_a_day=True
                        )
                    ),
                ]

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                for build_item in BUILD_ITEMS:
                    branch_part.append(
                        jg_build.JobGraphElementYaMakeBuildBranched(
                            task_name="BUILD_RTC_{}".format(build_item),
                            build_item="{}".format(build_item),
                            job_arrows=(
                                jg_job_triggers.JobTriggerNewTag(
                                    parent_job_data=(
                                        jg_job_data.ParentDataOutput(
                                            input_key="arcadia_url",
                                            output_key=sandbox_constants.ARCADIA_URL_KEY,
                                        )
                                    )
                                )
                            ),
                            ctx={
                                "build_type": "relwithdebinfo",
                                "sym_dump": "61581470",
                                "_grp_build_system_params": "null",
                            },
                            out={
                                "{}_BUNDLE".format(build_item): 90,
                            },
                        )
                    )
                    branch_part.append(
                        jg_build.JobGraphElementYaMakeBuildBranched(
                            task_name="BUILD_RTC_{}_CONFIG".format(build_item),
                            build_item="{}_CONFIG".format(build_item),
                            job_arrows=(
                                jg_job_triggers.JobTriggerNewTag(
                                    parent_job_data=(
                                        jg_job_data.ParentDataOutput(
                                            input_key="arcadia_url",
                                            output_key=sandbox_constants.ARCADIA_URL_KEY,
                                        )
                                    )
                                )
                            ),
                            out={
                                "{}_CONFIG_BUNDLE".format(build_item): 90,
                                "{}_ALPHA_CONFIG_BUNDLE".format(build_item): 90,
                                "{}_LOOP_CONF".format(build_item): 90,
                            },
                        )
                    )

                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="YA_MAKE_2",
                        build_item="ARCADIA_TESTS",
                        job_params={
                            "apiargs": {
                                "requirements": {
                                    "ram": 24 * 1024 ** 3,  # 24 Gb
                                    "disk_space": 80 * (1024 ** 3),  # 80 Gb
                                }
                            }
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="arcadia_url",
                                        output_key=sandbox_constants.ARCADIA_URL_KEY,
                                    )
                                )
                            )
                        ),
                        ctx={
                            'targets': 'rtc/sipgw;rtc/janus;rtc/balancer',
                            'clear_build': False,
                            'test': True,
                            'report_tests_only': True,
                            'disable_test_timeout': True,
                            'cache_test_results': False,
                            'tests_retries': 2,
                        },
                    )
                )

                deploy_triggers = []
                for build_item in BUILD_ITEMS:
                    deploy_triggers.append(
                        jg_job_triggers.JobTriggerBuild(
                            job_name_parameter="{}".format(build_item),
                            parent_job_data=(
                                jg_job_data.ParentDataId(
                                    input_key="{}_id".format(build_item.lower()),
                                ),
                            )
                        )
                    )
                    deploy_triggers.append(
                        jg_job_triggers.JobTriggerBuild(
                            job_name_parameter="{}_CONFIG".format(build_item),
                            parent_job_data=(
                                jg_job_data.ParentDataId(
                                    input_key="{}_config_id".format(build_item.lower()),
                                ),
                            )
                        )
                    )

                for release_type in [
                    rm_const.ReleaseStatus.prestable,
                    rm_const.ReleaseStatus.stable,
                ]:
                    branch_part.append(
                        jg_test.JobGraphElementTestBranchCommon(
                            task_name="DEPLOY_NANNY_DASHBOARD_DEV",
                            job_params={
                                "job_name_parameter": "DEPLOY_{}".format(release_type.upper()),
                            },
                            job_arrows=(
                                jg_job_triggers.JobTriggerRelease(
                                    job_name_parameter=release_type,
                                ),
                                jg_arrows.ParentsData(
                                    input_key="deployment_task_id",
                                    triggers=deploy_triggers,
                                    transform=lambda **kwargs: ",".join(map(str, kwargs.values()))
                                )
                            ),
                            ctx={
                                "deployment_nanny_dashboard_name": "sipgw",
                                "deployment_nanny_dashboard_recipe": "alpha-seq" if release_type == rm_const.ReleaseStatus.prestable else "prod-seq",
                                "deployment_release_status": release_type,
                                "deployment_nanny_bool_wait": True,
                                "services_skip_without_release_ticket": True,
                                "services_from_recipe": True,
                                "vault_name": "nanny_oauth_token",
                                "vault_owner": "RTC",
                                "wait_deployment": "120",
                            },
                        )
                    )

                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                for release_stage in [rm_const.ReleaseStatus.prestable, rm_const.ReleaseStatus.stable]:
                    triggers = []
                    for build_item in BUILD_ITEMS:
                        triggers.append(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="{}".format(build_item),
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        '{}_bundle'.format(build_item.lower()),
                                        '{}_BUNDLE'.format(build_item),
                                    )
                                )
                            )
                        )
                        triggers.append(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="{}_CONFIG".format(build_item),
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        '{}_config_bundle'.format(build_item.lower()),
                                        '{}_CONFIG_BUNDLE'.format(build_item),
                                    )
                                )
                            )
                        )
                    triggers.append(
                        jg_job_triggers.JobTriggerBuild(
                            job_name_parameter="ARCADIA_TESTS",
                        )
                    )

                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            release_to=release_stage,
                            job_arrows=triggers,
                        )
                    )
                    release_part.append(
                        jg_release.JobGraphElementActionReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerTestBranchCommon(
                                    job_name_parameter="DEPLOY_{}".format(release_stage.upper()),
                                ),
                            ),
                        )
                    )
                return release_part

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            queue = "RTC"
            summary_template = u"RTC Sipgw release {}"
            assignee = "robot-rtc-reis"
            followers = configs.PeopleGroups(
                abc_services=[configs.Abc(component_id=4050, role_id=16)],
                staff_groups=None,
                logins=None,
            )
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            close_linked_tickets = True

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        dirs = [
            "arcadia/rtc/balancer",
            "arcadia/rtc/sipgw",
            "arcadia/rtc/configs/sipgw",
            "arcadia/rtc/sip/",
            "arcadia/rtc/janus/",
            "arcadia/rtc/configs/sipgw-relay",
            "arcadia/rtc/configs/sipgw-balancer",
        ]
        wiki_page = "rtc/sipgw/releases/"
