# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
from sandbox.projects.release_machine.components.config_core import notifications as rm_notifications
from sandbox.projects.common import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class RtccCfg(configs.ReferenceTaggedConfig):
    name = "rtcc"
    display_name = u"RTCC"
    responsible = "elshiko"

    class Releases(configs.ReferenceTaggedConfig.Releases):
        resources_info = [
            configs.ReleasedResourceInfo(
                name="rtcc_bundle",
                resource_type="RTCC_BUNDLE",
            ),
        ]

        allow_old_releases = True
        allow_robots_to_release_stable = True

    class Yappy(yappy_cfg.YappyBaseCfg):
        betas = {
            "web": yappy_cfg.YappyTemplateCfg(
                template_name="noapache-web",
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="noapache-web",
                        resources=[yappy_cfg.YappyParametrizedResource(local_path="BUNDLE", param_name="rtcc_bundle")],
                        parent_service="hamster_noapache_vla_web_yp",
                    ),
                ],
            ),
            "video": yappy_cfg.YappyTemplateCfg(
                template_name="noapache-video",
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="noapache-video",
                        resources=[yappy_cfg.YappyParametrizedResource(local_path="BUNDLE", param_name="rtcc_bundle")],
                        parent_service="hamster_noapache_vla_video_yp",
                    ),
                ],
            ),
            "images": yappy_cfg.YappyTemplateCfg(
                template_name="noapache-images",
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="noapache-images",
                        resources=[yappy_cfg.YappyParametrizedResource(local_path="BUNDLE", param_name="rtcc_bundle")],
                        parent_service="hamster_noapache_vla_imgs_yp",
                    ),
                ],
            ),
        }

    class SvnCfg(configs.ReferenceTaggedConfig.SvnCfg):
        tag_name = "rtcc"
        tag_folder_template = r"{tag_prefix}{tag_num}"

    class Notify(configs.ReferenceTaggedConfig.Notify):

        use_startrek = False

        notifications = [
            rm_notifications.Notification(
                event_type="AcceptanceTest",
                chat_name="rtcc_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="BuildTest",
                chat_name="rtcc_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="ReleaseFailed",
                chat_name="rtcc_comp",
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="ReleaseDeployed",
                chat_name="rtcc_comp",
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_deployed_oldschool.html",
            ),
            rm_notifications.Notification(
                event_type="ReleaseCreated",
                chat_name="rtcc_comp",
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_created_oldschool.html",
            ),
        ]

        class Telegram(configs.ReferenceTaggedConfig.Notify.Telegram):
            chats = ["rtcc_comp"]

    class Testenv(configs.ReferenceTaggedConfig.Testenv):
        trunk_task_owner = "RUNTIME"

        class JobGraph(configs.ReferenceTaggedConfig.Testenv.JobGraph):
            @property
            def _tag_part(self):
                tag_part = [
                    jg_release.JobGraphElementNewTagTagged(),
                    jg_test.JobGraphElementTestTagCommon(
                        task_name="RUN_RTCC_UNIT_TESTS",
                        job_params={
                            "job_name_parameter": "UNITTESTS",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key=sandbox_constants.ARCADIA_URL_KEY,
                                        output_key="result_path",
                                        transform=lambda x, params: "{}/arcadia".format(x),
                                        override=True,
                                    ),
                                ),
                            ),
                        ),
                        out={"TASK_LOGS": 30},
                    ),
                    jg_test.JobGraphElementTestTagCommon(
                        task_name="RUN_RTCC_UNIT_TESTS",
                        job_params={
                            "job_name_parameter": "UNITTESTS_FOR_BETA",
                            "observed_paths": ["search/priemka/gencfg.upper", ],
                        },
                        job_arrows=(
                            jg_arrows.ParamsData(
                                input_key=sandbox_constants.ARCADIA_URL_KEY,
                                transform=lambda x, rm_config: "{}/arcadia@{}".format(x.svn_ssh_url, x.revision),
                            ),
                        ),
                    ),
                    jg_build.JobGraphElementYaMakeBuildTagged(
                        task_name="BUILD_UPPER_CONFIG",
                        build_item="TEST",
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="UNITTESTS",
                            ),
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key=sandbox_constants.ARCADIA_URL_KEY,
                                        output_key="result_path",
                                        transform=lambda x, params: "{}/arcadia".format(x),
                                        override=True,
                                    ),
                                ),
                            ),
                        ),
                        ctx={"use_arcadia": True},
                        out={"RTCC_BUNDLE": 30, "RTCC_CACHE": 30},
                    ),
                    jg_build.JobGraphElementYaMakeBuildTagged(
                        task_name="BUILD_UPPER_CONFIG",
                        build_item="TEST_FOR_BETA",
                        job_params={
                            "observed_paths": ["search/priemka/gencfg.upper", ],
                            "test_type": jg_utils.TestType.DIFF_TEST,
                            "compare_task_name": "BUILD_RTCC_DIFF",
                            "diff_resource_type": {"RTCC_BRIEF_DIFF": 40},
                            "has_diff": lambda ctx: int(ctx.get("has_diff")) > 0,
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="UNITTESTS_FOR_BETA",
                            ),
                            jg_arrows.ParamsData(
                                input_key=sandbox_constants.ARCADIA_URL_KEY,
                                transform=lambda x, rm_config: "{}/arcadia@{}".format(x.svn_ssh_url, x.revision),
                                override=True,
                            ),
                            jg_arrows.ParamsData(
                                input_key="commit_author",
                                transform=lambda x, rm_config: x.commit_author,
                            )
                        ),
                        ctx={"use_arcadia": True},
                        out={"RTCC_BUNDLE": 30, "RTCC_CACHE": 30},
                    ),
                    jg_build.JobGraphElementYaMakeBuildTagged(
                        task_name="BUILD_RTCC_DIFF",
                        build_item="DIFF",
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="TEST",
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="production_new_bundle",
                                        resource_name="RTCC_BUNDLE",
                                    ),
                                    jg_job_data.ParentDataResource(
                                        input_key="production_new_cache",
                                        resource_name="RTCC_CACHE",
                                    ),
                                )
                            ),
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key=sandbox_constants.ARCADIA_URL_KEY,
                                        output_key="result_path",
                                        transform=lambda x, params: "{}/arcadia".format(x),
                                        override=True,
                                    ),
                                ),
                            ),
                        ),
                        out={"RTCC_BRIEF_DIFF": 30},
                    ),

                ]
                for beta_type, template_quota in [
                    ("web", "web-ranking-runtime"),
                    ("images", "images-ranking"),
                    ("video", "video-quality"),
                ]:
                    tag_part.append(
                        jg_test.JobGraphElementYappyBetaGeneratorTagged(
                            beta_conf_type=beta_type,
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="TEST",
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            "component_resources",
                                            "rtcc_bundle",
                                            "RTCC_BUNDLE",
                                        )
                                    )
                                ),
                            )
                        )
                    )
                    tag_part.append(
                        jg_test.JobGraphElementLaunchMetrics(
                            search_subtype=beta_type,
                            job_arrows=(
                                jg_job_triggers.JobTriggerGenerateBeta(
                                    job_name_parameter=beta_type,
                                    parent_job_data=(
                                        jg_job_data.ParentDataCtx(
                                            input_key="checked_beta",
                                            output_key="beta_name",
                                            transform=lambda x, params: "{}.hamster".format(x),
                                        ),
                                    )
                                )
                            ),
                            ctx={
                                "custom_template_name": "common.json",
                                "launch_template_quota": template_quota,
                                "component_name": "rtcc",
                                "sample_beta": "upper-hamster.hamster",
                                "run_findurl": True,
                            }
                        )
                    )
                return tag_part

            @property
            def _release(self):
                default_release_part = super(self.__class__, self)._release
                release_part = [
                    jg_prerelease.JobGraphElementPreliminaryChangelogTagged(),
                    jg_release.JobGraphElementReleaseTagged(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="DIFF",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="do_release",
                                        output_key="has_diff",
                                        transform=lambda x, params: str(x),
                                    ),
                                    jg_job_data.ParentDataCtx(
                                        input_key="release_notes_comment",
                                        output_key="marty_release_info",
                                        transform=lambda x, params: "\nInfo about rtcc diff: {}\n".format(x),
                                    ),
                                )
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="TEST",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "rtcc_bundle",
                                        "RTCC_BUNDLE",
                                    ),
                                ),
                            ),
                        )
                    ),
                    jg_release.JobGraphElementActionReleaseTagged(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_params={
                            "next_revision_custom_schedule": jg_utils.CustomSchedule(
                                time_interval_list=[(6, 6)],
                                seconds_from_last_run_commit=20 * 3600,
                            )
                        }
                    ),
                ]
                return default_release_part + release_part

    def __init__(self):
        super(RtccCfg, self).__init__()
        self.yappy_cfg = self.Yappy()
        self.metrics_cfg = self.MetricsCfg()
