# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri

from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets


class SaasSSMCfg(configs.ReferenceCIConfig):
    name = "saas_ssm"  # Id, not human-readable
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="saas"),
        login="saas-robot",
    )

    class JG(basic_build_presets.SingleBuildYaPackageJGCfg):
        pass

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "saas/tools/user_if/ssm-front"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "RTYSERVER-ROBOT"

        ya_make_abs_paths_glob = [
            "saas/tools/ssm/**",
            "saas/tools/user_if/ssm-front/**",
            "saas/tools/devops/lib/**",
            "saas/tools/devops/lib2/**",
            "saas/tools/devops/lib23/**",
            "saas/library/python/**",
        ]  # How to find commits

        grant_config_update_permissions_to_release_machine_robot = False

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="ssm_package",
                    data=ri.SandboxResourceData("SAAS_SSM_PACKAGE", ttl=180),
                    build_data=ri.BuildData(
                        target="saas/tools/user_if/ssm-front/pkg.json",
                    ),
                    deploy_infos=[
                        ri.single_nanny_service("saas_cloud_service_manager"),
                    ],
                ),
            ]
        allow_old_releases = True
        allow_robots_to_release_stable = True
        release_followers_permanent = [
            "saas-robot",
        ]

    class Notify(configs.ReferenceCIConfig.Notify):
        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "i024"
            queue = "SAAS"
            dev_queue = "SAAS"
            summary_template = u"Приемка SSM {}"
            workflow = {}
            followers = [
                "i024",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = "jandekspoisk/saas/support/infra/ssm"
        dirs = [
            "saas/tools/ssm/",
            "saas/tools/user_if/ssm-front/",
            "saas/tools/devops/lib/",
            "saas/tools/devops/lib2/",
            "saas/tools/devops/lib23/",
            "saas/library/python/",
        ]
