# -*- coding: utf-8 -*-
from sandbox.projects.common.constants import constants as common_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers


class SawmillCfg(configs.ReferenceBranchedConfig):
    name = "sawmill"
    responsible = "lebedev-aa"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "SAWMILL"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementWikiNoStartrek(),
                    jg_prerelease.JobGraphElementActionPreReleaseBase(
                        job_arrows=(
                            jg_job_triggers.JobTriggerWiki(),
                        )
                    ),
                ]

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(jg_build.JobGraphElementBuildBranched(
                    task_name="BUILD_SAWMILL",
                    build_item="BINARY",
                    out={"SAWMILL_BINARY": 40},
                    ctx={
                        "target_resources": "SAWMILL_BINARY",
                        common_const.BUILD_SYSTEM_KEY: common_const.YMAKE_BUILD_SYSTEM,
                        common_const.USE_AAPI_FUSE: True,
                        common_const.TESTS_REQUESTED: True,
                    },
                ))
                branch_part.append(jg_build.JobGraphElementBuildBranched(
                    task_name="BUILD_SAWMILL",
                    build_item="AGENT",
                    out={"SAWMILL_AGENT": 40},
                    ctx={
                        "target_resources": "SAWMILL_AGENT",
                        common_const.BUILD_SYSTEM_KEY: common_const.YMAKE_BUILD_SYSTEM,
                        common_const.USE_AAPI_FUSE: True,
                        common_const.TESTS_REQUESTED: True,
                    },
                ))
                return branch_part

            @property
            def _release(self):
                binary_job_arrows = (
                    jg_job_triggers.JobTriggerBuild(
                        parent_job_data=[
                            jg_job_data.ParentDataDict(
                                input_key="component_resources",
                                dict_key="sawmill_binary",
                                resource_name="SAWMILL_BINARY",
                            ),
                        ],
                        job_name_parameter="BINARY",
                    ),
                    jg_job_triggers.JobTriggerNewTag([
                        jg_job_data.ParentDataOutput('major_release_num', 'branch_number_for_tag'),
                        jg_job_data.ParentDataOutput('minor_release_num', 'new_tag_number'),
                    ]),
                )
                return super(self.__class__, self)._release + [
                    jg_release.JobGraphElementReleasePushBranched(
                        task_name="SCHEDULE_RELEASE",
                        release_to=rm_const.ReleaseStatus.testing,
                        release_item="BINARY",
                        job_arrows=binary_job_arrows,
                        job_params={
                            "ctx": {
                                "deploy_system": rm_const.DeploySystem.nanny_push.name,
                                "flows": ["deploy"],
                                "warden_component_name": "sawmill",
                                "warden_parent_component_name": "sawmill",
                            }
                        },
                    ),
                    jg_release.JobGraphElementActionPushReleaseBranched(
                        release_to=rm_const.ReleaseStatus.testing,
                        release_item="BINARY",
                    ),
                    jg_release.JobGraphElementReleasePushBranched(
                        task_name="SCHEDULE_RELEASE",
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="BINARY",
                        job_arrows=binary_job_arrows,
                        job_params={
                            "ctx": {
                                "deploy_system": rm_const.DeploySystem.nanny_push.name,
                                "flows": ["deploy"],
                                "warden_component_name": "sawmill",
                                "warden_parent_component_name": "sawmill",
                            }
                        },
                    ),
                    jg_release.JobGraphElementActionPushReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="BINARY",
                    ),
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="AGENT",
                        job_arrows=jg_job_triggers.JobTriggerBuild(
                            parent_job_data=[
                                jg_job_data.ParentDataDict(
                                    input_key="component_resources",
                                    dict_key="sawmill_agent",
                                    resource_name="SAWMILL_AGENT",
                                ),
                            ],
                            job_name_parameter="AGENT",
                        ),
                        job_params={
                            "ctx": {
                                "deploy_system": rm_const.DeploySystem.nanny_push.name,
                            }
                        },
                    ),
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="AGENT",
                    )
                ]

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            deploy_infos = [
                ri.single_nanny_service("sawmill"),
                ri.single_nanny_service("sawmill-dev", rm_const.ReleaseStatus.testing),
            ]
            return [
                ri.ReleasableItem(
                    "sawmill_binary",
                    ri.SandboxResourceData("SAWMILL_BINARY"),
                    deploy_infos=deploy_infos
                ),
                ri.ReleasableItem(
                    "sawmill_agent",
                    ri.SandboxResourceData("SAWMILL_AGENT"),
                    deploy_infos=deploy_infos
                ),
                ri.DynamicReleasableItem(
                    "scheduled_bundle",
                    ri.SandboxResourceData("SCHEDULED_RM_RELEASE_DATA"),
                    [
                        ri.NannyDeployInfo(),
                        ri.NannyDeployInfo(stage=rm_const.ReleaseStatus.testing),
                    ],
                ),
            ]
        deploy_system = rm_const.DeploySystem.nanny_push
        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceBranchedConfig.Notify):
        use_startrek = False

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["yappy-dev"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "sawmill/Releases/"
        dirs = [
            "arcadia/search/martylib",
            "arcadia/search/sawmill",
        ]

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "sawmill"
        tag_name = "sawmill"
