# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.configs.sb_tasks import _base as sb_cfg_base


class ReleaseMachineTasksBaseCfg(sb_cfg_base.SandboxSingleTaskReleaseCfg):
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="releasemachine"),
        login="ilyaturuntaev",
    )

    @property
    def target_task_ci_registry_location(self):
        return "projects/release_machine/{task_type}".format(
            task_type=self.target_task_type.lower(),
        )

    class CI(sb_cfg_base.SandboxSingleTaskReleaseCfg.CI):
        sb_owner_group = "RELEASE_MACHINE"

        @property
        def ya_make_abs_paths_glob(self):
            return super(ReleaseMachineTasksBaseCfg.CI, self).ya_make_abs_paths_glob + [
                "sandbox/projects/release_machine/components/configs/**",
            ]
