# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.components.configs.sb_tasks import _release_machine_tasks as rm_task_base
from sandbox.projects.release_machine.components.config_core.jg import cube as jg_cube


class LaunchMetricsCfg(rm_task_base.ReleaseMachineTasksBaseCfg):
    name = "launch_metrics"
    target_task_path = "sandbox/projects/release_machine/tasks/LaunchMetrics/bin"
    target_task_ci_registry_location = "projects/release_machine/launch_metrics"

    @property
    def test_run_input(self):
        return jg_cube.CubeInput(
            run_findurl=False,
            sample_beta="hamster",
            checked_beta="hamster",
            custom_template_name="experiments.json",
            release_number=0,
            minor_release_number=0,
            launch_template_quota="web-ranking-runtime",
            enable_autoclicker=True,
            scraper_over_yt_pool="experiments_rm",
        )
