# -*- coding: utf-8 -*-


from sandbox.projects.release_machine.components.configs.sb_tasks import _release_machine_tasks as rm_task_base
from sandbox.projects.release_machine.components.config_core.jg import cube as jg_cube


class MergeToStableCfg(rm_task_base.ReleaseMachineTasksBaseCfg):
    name = "merge_to_stable"
    target_task_path = "sandbox/projects/release_machine/tasks/MergeToStable/bin"

    add_precommit_check = True

    @property
    def test_run_input(self):
        return jg_cube.CubeInput(
            do_commit=False,
            need_check=False,
            merge_mode_type="release_machine",
            component_name="release_machine_test",
            revs="6891857, 6891858",
            kill_timeout=600,
        )
