# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.components.configs.sb_tasks import _base as sb_cfg_base
from sandbox.projects.release_machine.components.configs.sb_tasks import _release_machine_tasks as rm_task_base
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow
from sandbox.projects.release_machine.components.config_core.jg import cube as jg_cube
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import internal as internal_cubes
from sandbox.projects.release_machine.core import const as rm_const

STAGE_RUN_PREPARE_CI_ENV = jg_flow.ReleaseActionStageData(
    "run",
    cube_names=[
        "prepare_ci_environment",
    ],
    displace={
        "on-status": [
            "FAILURE",
        ],
    },
)

PREPARE_CI_ENV_STAGES = sb_cfg_base.RELEASE_FLOW_STAGES + [STAGE_RUN_PREPARE_CI_ENV]


class PrepareCiEnvironmentCfg(rm_task_base.ReleaseMachineTasksBaseCfg):
    name = "prepare_ci_environment"
    target_task_path = "sandbox/projects/release_machine/tasks/PrepareCiEnvironment/bin"

    class JG(rm_task_base.ReleaseMachineTasksBaseCfg.JG):

        COMPONENT_AUTOGEN_BLACKLIST = rm_const.COMPONENT_AYAML_AUTOGEN_BLACKLIST

        @jg_flow.release_flow(
            auto=True,
            stages=PREPARE_CI_ENV_STAGES,
        )
        def release(self):
            graph = super(PrepareCiEnvironmentCfg.JG, self).release(self)

            prepare_ci_environment = internal_cubes.PrepareCiEnvironment(
                self.component_name,
                input=jg_cube.CubeInput(
                    create_review=True,
                    component_name_forced_ignore=self.COMPONENT_AUTOGEN_BLACKLIST,
                ),
                needs=[
                    graph.get("release_sb_stable__prepare_ci_environment"),
                ],
            )

            graph.add(prepare_ci_environment)

            return graph

    class SvnCfg(rm_task_base.ReleaseMachineTasksBaseCfg.SvnCfg):
        start_version = 1173
