# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import crawler as crawler_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.configs.sb_tasks import _release_machine_tasks as rm_task_base
from sandbox.projects.release_machine.components.configs.sb_tasks import _base as sb_task_base


STAGE_RUN_CRAWLER = jg_flow.ReleaseActionStageData(
    "run",
    cube_names=[
        "run_entry",
        "crawl_testing",
        "crawl_production",
    ],
    displace=sb_task_base.DISPLACE,
)

RUN_CRAWLER_STAGES = sb_task_base.RELEASE_FLOW_STAGES + [STAGE_RUN_CRAWLER]


class ReleaseMachineConfigCrawlerCfg(rm_task_base.ReleaseMachineTasksBaseCfg):
    name = "release_machine_config_crawler"
    target_task_path = "sandbox/projects/release_machine/tasks/ReleaseMachineConfigCrawler/bin"

    def _get_launch(self, host):
        return

    class JG(rm_task_base.ReleaseMachineTasksBaseCfg.JG):

        @jg_flow.release_flow(
            auto=True,
            stages=RUN_CRAWLER_STAGES,
        )
        def release(self):

            graph = super(ReleaseMachineConfigCrawlerCfg.JG, self).release(self)

            stable_release = graph.get("release_sb_stable__release_machine_config_crawler")

            run_entry = dummy_cubes.Dummy("run_entry", needs=[stable_release])

            crawl_testing = crawler_cubes.ReleaseMachineConfigCrawler(
                name="crawl_testing",
                rm_host=rm_const.Urls.RM_TESTING_HOST,
                light_mode=True,
                update_declarative_notifications=False,
                needs=[run_entry],
            )

            crawl_production = crawler_cubes.ReleaseMachineConfigCrawler(
                name="crawl_production",
                rm_host=rm_const.Urls.RM_HOST,
                light_mode=False,
                update_declarative_notifications=True,
                needs=[run_entry],
            )

            graph.add(run_entry)
            graph.add(crawl_testing)
            graph.add(crawl_production)

            return graph
