# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components.config_core.jg.cube import base as jg_cube
from sandbox.projects.release_machine.components.configs.sb_tasks import _release_machine_tasks as rm_task_base


class RunIceFlameCfg(rm_task_base.ReleaseMachineTasksBaseCfg):

    name = "run_ice_flame"
    target_task_path = "sandbox/projects/release_machine/tasks/RunIceFlame/bin"
    target_task_ci_registry_location = "projects/iceflame/run_ice_flame"

    @property
    def test_run_input(self):
        return jg_cube.CubeInput(
            debug=True,
            dry_run=True,
            release_machine_mode=False,
            iceflame_config_file="iceflame_task_test.conf",
            ssh_login="robot-srch-releaser",
            ssh_key_secret="sec-01ejz9hcr8tq4mmwga719ecgt0#ssh_key",
            sandbox_token_secret="sec-01ejz9hcr8tq4mmwga719ecgt0#common_release_token",
            nanny_token_secret="sec-01ejz9hcr8tq4mmwga719ecgt0#common_release_token",
            iceflame_command_run_options_json={
                "remote_collector_options": {
                    "analyze_inplace": True,
                    "build_flamegraph": True,
                },
            },
        )

    class SvnCfg(rm_task_base.ReleaseMachineTasksBaseCfg.SvnCfg):
        start_version = 2017
