from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.configs.sb_tasks import _base as sb_cfg_base
from sandbox.projects.release_machine.components.config_core.jg import cube as jg_cube

TASKS_RESOURCE_NAME = "UpdateSaasSearchmap"
TASKS_RESOURCE_OWNER = "RTYSERVER-ROBOT"


class UpdateSaasSearchmapCfg(sb_cfg_base.SandboxSingleTaskReleaseCfg):
    name = "update_saas_searchmap"
    target_task_path = "sandbox/projects/saas/UpdateSaasSearchmap"

    responsible = configs.Responsible(
        abc=configs.Abc(service_name="saas"),
        login="kniv",
    )

    release_to_stable_manually = False

    add_precommit_check = True

    class CI(sb_cfg_base.SandboxSingleTaskReleaseCfg.CI):
        sb_owner_group = TASKS_RESOURCE_OWNER

    @property
    def task_binary_resource_additional_attributes(self):
        return {
            "name": TASKS_RESOURCE_NAME,
        }

    @property
    def test_run_input(self):
        return jg_cube.CubeInput(update_in_mds=False)
