# -*- coding: utf-8 -*-

import json

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components import configs
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
from sandbox.projects.release_machine.components.config_core import notifications as rm_notifications


class ScraperOverYtCfg(configs.ReferenceBranchedConfig):
    component_group = "reference_component_metricsed"
    name = "scraper_over_yt"
    responsible = "i024"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "SEARCH-RELEASERS"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _trunk_part(self):
                trunk_part = super(self.__class__, self)._trunk_part

                trunk_part.append(
                    jg_test.JobGraphElementRunIceFlame(
                        config_file="scraper_over_yt_scheduler.conf",
                        job_params={
                            "should_add_to_db": jg_utils.should_add_to_db_trunk,
                            "frequency": (jg_utils.TestFrequency.DEFINED_BY_CODE, None),
                            "next_revision_custom_schedule": jg_utils.CustomSchedule(
                                time_interval_list=[(7, 9)],
                                seconds_from_last_run_commit=1.5 * 3600,
                                once_a_day=True,
                            ),
                        },
                        ctx={
                            "release_item_name": "scraper_over_yt_dynamic_scheduler_id",
                            "service_name": "soy_production_dynamic_scheduler_hahn",
                            "fail_if_service_version_cannot_be_determined": True,
                            "check_production_version": True,
                            "iceflame_command_run_options_json": {
                                "remote_collector_options": {
                                    "analyze_inplace": True,
                                    "build_flamegraph": True,
                                    "analyzer_timeout": 1200,
                                },
                                "apply_config_patch": "soy_active_lock",  # задаем патч
                            },
                            "env_vars": "TOKEN='$(yav:sec-01d4j8tqzmwng35pnxvw51dgx4#YT_TOKEN)'",
                        },
                    ),
                )

                trunk_part.append(
                    jg_test.JobGraphElementRunIceFlame(
                        config_file="scraper_over_yt_mover.conf",
                        job_params={
                            "should_add_to_db": jg_utils.should_add_to_db_trunk,
                            "frequency": (jg_utils.TestFrequency.DEFINED_BY_CODE, None),
                            "next_revision_custom_schedule": jg_utils.CustomSchedule(
                                time_interval_list=[(7, 9)],
                                seconds_from_last_run_commit=1.5 * 3600,
                                once_a_day=True,
                            ),
                            "job_name_parameter": "MOVER_ICEFLAME",
                        },
                        ctx={
                            "release_item_name": "scraper_over_yt_mover_id",
                            "service_name": "soy_production_mover_hahn",
                            "fail_if_service_version_cannot_be_determined": True,
                            "check_production_version": True,
                        },
                    ),
                )

                return trunk_part

            @property
            def _branch_part(self):
                default_branch_part = super(self.__class__, self)._branch_part
                filter_json = {
                    "default": {
                        "enable": True,
                        "important": False,
                        "maxRowsByTable": 32,
                        "filterTime": 3600,
                        "maxSelectedTables": 20,
                        "minRowsByTable": 10,
                        "minRowsPool": 15,
                        "maxRunningJobs": 10,
                        "allowHosts": 'hamster.yandex.ru',
                        "skipParams": 'srcrwr=UPPER'
                    }
                }
                branch_part = [
                    jg_build.JobGraphElementBuildPackageBranched(
                        resource_names="SCRAPER_OVER_YT_BUNDLE",
                        package_names="search/scraper_over_yt/package.json",
                        task_name="KOSHER_YA_PACKAGE",
                        job_params={
                            "apiargs": {
                                "requirements": {
                                    "disk_space": 900 * (1024 ** 3),  # 900 Gb
                                },
                            },
                            "job_name_parameter": "BUNDLE",
                        },
                        use_compression=False,
                        ctx={
                            "use_new_format": True,
                            "docker_registry": "registry.yandex.net",
                            "musl": True,
                            "raw_package": True,
                        },
                        out={"SCRAPER_OVER_YT_BUNDLE": 20},
                    ),
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        build_item="SCHEDULER",
                        ctx={
                            "musl": True,
                            "targets": "search/scraper_over_yt/daemons/scheduler/scheduler",
                            "result_single_file": True,
                            "arts": "search/scraper_over_yt/daemons/scheduler/scheduler",
                            "result_rd": "scheduler",
                            "result_rt": "SCRAPER_OVER_YT_SCHEDULER"
                        },
                        out={"SCRAPER_OVER_YT_SCHEDULER": 20},
                    ),
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        build_item="DYNAMIC_SCHEDULER",
                        ctx={
                            "musl": True,
                            "targets": "search/scraper_over_yt/daemons/dynamic_scheduler/dynamic_scheduler",
                            "result_single_file": True,
                            "arts": "search/scraper_over_yt/daemons/dynamic_scheduler/dynamic_scheduler",
                            "result_rd": "dynamic_scheduler",
                            "result_rt": "SCRAPER_OVER_YT_DYNAMIC_SCHEDULER"
                        },
                        out={"SCRAPER_OVER_YT_DYNAMIC_SCHEDULER": 20},
                    ),
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        build_item="API_SERVER",
                        ctx={
                            "musl": True,
                            "targets": "search/scraper_over_yt/daemons/api_server/api_server",
                            "result_single_file": True,
                            "arts": "search/scraper_over_yt/daemons/api_server/api_server",
                            "result_rd": "api_server",
                            "result_rt": "SCRAPER_OVER_YT_API_SERVER"
                        },
                        out={"SCRAPER_OVER_YT_API_SERVER": 20},
                    ),
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        build_item="MOVER",
                        ctx={
                            "musl": True,
                            "targets": "search/scraper_over_yt/daemons/mover/mover",
                            "result_single_file": True,
                            "arts": "search/scraper_over_yt/daemons/mover/mover",
                            "result_rd": "mover",
                            "result_rt": "SCRAPER_OVER_YT_MOVER"
                        },
                        out={"SCRAPER_OVER_YT_MOVER": 20},
                    ),
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        build_item="WORKER",
                        ctx={
                            "musl": True,
                            "targets": "search/scraper_over_yt/worker/worker",
                            "result_single_file": True,
                            "arts": "search/scraper_over_yt/worker/worker",
                            "result_rd": "worker",
                            "result_rt": "SCRAPER_OVER_YT_WORKER"
                        },
                        out={"SCRAPER_OVER_YT_WORKER": 20},
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="SCRAPER_OVER_YT_TEST_MANAGER",
                        job_params={
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                            "job_name_parameter": "DEPLOY_AND_DOWNLOAD_SOME_BATCHES",
                        },
                        ctx={
                            "description": "SOY TESTS",
                            "processed_path": "//home/search-runtime/robot-scraperoveryt/scraper_over_yt/scheduler/operations_queue/processed",
                            "filter_string": json.dumps(filter_json),
                            "path_to_create": "//home/search-runtime/desertfury/scraper_over_yt/scheduler",
                            "proxy": "hahn",
                            "yt_token_owner": "robot-soy-tester",
                            "yt_token_name": "robot_soy_tester_token",
                            "soy_token_name": "robot_soy_tester_soy_token",
                            "soy_api": "https://testing.soyproxy.yandex.net/hahn/soy_api",
                            "thread_count": 1,
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerRelease(
                                job_name_parameter=rm_const.ReleaseStatus.testing,
                            ),
                            jg_arrows.ParentsData(
                                "build_task_id_by_receipt",
                                triggers=(
                                    jg_job_triggers.JobTriggerBuild(
                                        parent_job_data=(
                                            jg_job_data.ParentDataId(
                                                "deploy_soy_testing_bundle"
                                            )
                                        ),
                                        job_name_parameter="BUNDLE",
                                    ),
                                    jg_job_triggers.JobTriggerBuild(
                                        parent_job_data=(
                                            jg_job_data.ParentDataId(
                                                "deploy_soy_testing_scheduler"
                                            )
                                        ),
                                        job_name_parameter="SCHEDULER",
                                    ),
                                    jg_job_triggers.JobTriggerBuild(
                                        parent_job_data=(
                                            jg_job_data.ParentDataId(
                                                "deploy_soy_testing_dynamic_scheduler"
                                            )
                                        ),
                                        job_name_parameter="DYNAMIC_SCHEDULER",
                                    ),
                                    jg_job_triggers.JobTriggerBuild(
                                        parent_job_data=(
                                            jg_job_data.ParentDataId(
                                                "deploy_soy_testing_api_server"
                                            )
                                        ),
                                        job_name_parameter="API_SERVER",
                                    ),
                                    jg_job_triggers.JobTriggerBuild(
                                        parent_job_data=(
                                            jg_job_data.ParentDataId(
                                                "deploy_soy_testing_mover"
                                            )
                                        ),
                                        job_name_parameter="MOVER",
                                    ),
                                    jg_job_triggers.JobTriggerBuild(
                                        parent_job_data=(
                                            jg_job_data.ParentDataId(
                                                "deploy_soy_testing_worker"
                                            )
                                        ),
                                        job_name_parameter="WORKER",
                                    ),
                                ),
                                transform=lambda **kwargs: kwargs
                            ),
                        )
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="LAUNCH_METRICS",
                        job_params={
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                            "job_name_parameter": "DOWNLOAD_METRICS",
                        },
                        ctx={
                            "metrics_mode_type": "release_machine",
                            "component_name": "scraper_over_yt",
                            "custom_template_name": "experiments_soy_testing.json",
                            "custom_template_descr": "soy release priemka",
                            "sample_beta": "hamster",
                            "checked_beta": "hamster",
                            "enable_autoclicker": False,
                            "scraper_over_yt_pool": "default"
                        },
                        job_arrows=(
                            jg_arrows.ParamsData("release_number", jg_utils.get_major_release_number),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="DEPLOY_AND_DOWNLOAD_SOME_BATCHES",
                            ),
                        ),
                    )
                ]
                return default_branch_part + branch_part

            @property
            def _release(self):
                default_release_part = super(self.__class__, self)._release
                release_part = []
                for release_stage in [
                    rm_const.ReleaseStatus.stable,
                    rm_const.ReleaseStatus.prestable,
                    rm_const.ReleaseStatus.testing,
                ]:
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            task_name="RELEASE_RM_COMPONENT_2",
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            "component_resources",
                                            "scraper_over_yt_bundle_id",
                                            "SCRAPER_OVER_YT_BUNDLE"
                                        )
                                    ),
                                    job_name_parameter="BUNDLE",
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            "component_resources",
                                            "scraper_over_yt_scheduler_id",
                                            "SCRAPER_OVER_YT_SCHEDULER"
                                        )
                                    ),
                                    job_name_parameter="SCHEDULER",
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            "component_resources",
                                            "scraper_over_yt_dynamic_scheduler_id",
                                            "SCRAPER_OVER_YT_DYNAMIC_SCHEDULER"
                                        )
                                    ),
                                    job_name_parameter="DYNAMIC_SCHEDULER",
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            "component_resources",
                                            "scraper_over_yt_api_server_id",
                                            "SCRAPER_OVER_YT_API_SERVER"
                                        )
                                    ),
                                    job_name_parameter="API_SERVER",
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            "component_resources",
                                            "scraper_over_yt_mover_id",
                                            "SCRAPER_OVER_YT_MOVER"
                                        )
                                    ),
                                    job_name_parameter="MOVER",
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            "component_resources",
                                            "scraper_over_yt_worker_id",
                                            "SCRAPER_OVER_YT_WORKER"
                                        )
                                    ),
                                    job_name_parameter="WORKER",
                                ),
                                jg_job_triggers.JobTriggerNewTag(
                                    parent_job_data=[
                                        jg_job_data.ParentDataOutput('major_release_num', 'branch_number_for_tag'),
                                        jg_job_data.ParentDataOutput('minor_release_num', 'new_tag_number'),
                                    ],
                                ),
                            ),
                            job_params={
                                "apiargs": {
                                    "kill_timeout": 15 * 60,  # 15 min
                                },
                                "ctx": {
                                    "deploy_system": rm_const.DeploySystem.sandbox.name,
                                    "project": "scraper_over_yt",
                                    "wait_for_deploy": True
                                }
                            }
                        )
                    )
                for release_stage in [
                    rm_const.ReleaseStatus.stable,
                    rm_const.ReleaseStatus.prestable,
                ]:
                    release_part.append(
                        jg_release.JobGraphElementActionReleaseBranched(release_to=release_stage)
                    )

                release_part.append(
                    jg_release.JobGraphElementActionReleaseBranched(release_to=rm_const.ReleaseStatus.testing,
                                                                    job_params={
                                                                        "frequency": (
                                                                            jg_utils.TestFrequency.CHECK_EACH_COMMIT,
                                                                            None)
                                                                    }
                                                                    )
                )
                return default_release_part + release_part

    class ReleaseViewer(configs.ReferenceConfig.ReleaseViewer):
        kpi_alert = 7
        kpi_alert_skip_weekends = True

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            production_clusters = ["hahn", "arnold"]
            testing_clusters = ["hahn"]

            def apply_template(template, vals):
                return [template.format(val) for val in vals]

            def get_prod_services(template):
                return apply_template(template, production_clusters)

            def get_testing_services(template):
                return apply_template(template, testing_clusters)

            def make_deploy_services(objs):
                return [ri.DeployService(obj) for obj in objs]

            def make_prod_deploy_services(template):
                return make_deploy_services(get_prod_services(template))

            def make_testing_deploy_services(template):
                return make_deploy_services(get_testing_services(template))

            production_dynamic_scheduler_services = make_prod_deploy_services("soy_production_dynamic_scheduler_{}")
            testing_dynamic_scheduler_services = make_testing_deploy_services("soy_testing_dynamic_scheduler_{}")

            production_scheduler_services = make_prod_deploy_services("soy_production_scheduler_{}")
            testing_scheduler_services = make_testing_deploy_services("soy_testing_scheduler_{}")

            production_mover_services = make_prod_deploy_services("soy_production_mover_{}")
            testing_mover_services = make_testing_deploy_services("soy_testing_mover_{}")

            production_api_server_services = make_prod_deploy_services("api_server_production_{}")
            testing_api_server_services = make_testing_deploy_services("api_server_testing_{}")

            production_worker_services = make_deploy_services(["factory_production", "factory_production_arnold"])
            testing_worker_services = make_deploy_services(["factory_testing"])

            production_resolver_services = make_prod_deploy_services("soy_resolver_production_{}")
            testing_resolver_services = make_testing_deploy_services("soy_resolver_testing_{}")

            production_adaptive_load_services = make_prod_deploy_services("soy_adaptive_load_production_{}")
            testing_adaptive_load_services = make_testing_deploy_services("soy_adaptive_load_testing_{}")

            production_microservices_services = make_prod_deploy_services("soy_microservices_production_{}")
            testing_microservices_services = make_testing_deploy_services("soy_microservices_testing_{}")

            production_animals_proxies_services = make_prod_deploy_services("soy_production_animals_proxies_{}")
            testing_animals_proxies_services = []

            production_animals_resolver_services = make_prod_deploy_services("soy_production_animals_resolver_adaptive_{}")
            testing_animals_resolver_services = []

            production_bundle_services = production_resolver_services + production_adaptive_load_services + \
                                         production_microservices_services + production_animals_proxies_services + \
                                         production_animals_resolver_services
            testing_bundle_services = testing_resolver_services + testing_adaptive_load_services + \
                                      testing_microservices_services + testing_animals_proxies_services + \
                                      testing_animals_resolver_services

            return [
                ri.ReleasableItem(
                    name="scraper_over_yt_dynamic_scheduler_id",
                    data=ri.SandboxResourceData("SCRAPER_OVER_YT_DYNAMIC_SCHEDULER", dst_path="scheduler"),
                    deploy_infos=[
                        ri.NannyDeployInfo(production_dynamic_scheduler_services),
                        ri.NannyDeployInfo(testing_dynamic_scheduler_services, stage=rm_const.ReleaseStatus.testing),
                    ]
                ),
                ri.ReleasableItem(
                    name="scraper_over_yt_scheduler_id",
                    data=ri.SandboxResourceData("SCRAPER_OVER_YT_SCHEDULER", dst_path="scheduler"),
                    deploy_infos=[
                        ri.NannyDeployInfo(production_scheduler_services),
                        ri.NannyDeployInfo(testing_scheduler_services, stage=rm_const.ReleaseStatus.testing),
                    ]
                ),
                ri.ReleasableItem(
                    name="scraper_over_yt_bundle_id",
                    data=ri.SandboxResourceData("SCRAPER_OVER_YT_BUNDLE", dst_path="bundle"),
                    deploy_infos=[
                        ri.NannyDeployInfo(production_bundle_services),
                        ri.NannyDeployInfo(testing_bundle_services, stage=rm_const.ReleaseStatus.testing),
                    ]
                ),
                ri.ReleasableItem(
                    name="scraper_over_yt_mover_id",
                    data=ri.SandboxResourceData("SCRAPER_OVER_YT_MOVER", dst_path="mover"),
                    deploy_infos=[
                        ri.NannyDeployInfo(production_mover_services),
                        ri.NannyDeployInfo(testing_mover_services, stage=rm_const.ReleaseStatus.testing),
                    ]
                ),
                ri.ReleasableItem(
                    name="scraper_over_yt_api_server_id",
                    data=ri.SandboxResourceData("SCRAPER_OVER_YT_API_SERVER", dst_path="api_server"),
                    deploy_infos=[
                        ri.NannyDeployInfo(production_api_server_services),
                        ri.NannyDeployInfo(testing_api_server_services, stage=rm_const.ReleaseStatus.testing),
                    ]
                ),
                ri.ReleasableItem(
                    name="scraper_over_yt_worker_id",
                    data=ri.SandboxResourceData("SCRAPER_OVER_YT_WORKER", dst_path="worker"),
                    deploy_infos=[
                        ri.NannyDeployInfo(production_worker_services),
                        ri.NannyDeployInfo(testing_worker_services, stage=rm_const.ReleaseStatus.testing),
                    ]
                ),
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True
        deploy_system = rm_const.DeploySystem.sandbox

        infra_service_id = 1403
        infra_envs = {
            rm_const.ReleaseStatus.stable: 2221,
        }
        infra_event_duration_sec = 15 * 60  # 15 min

    class Notify(configs.ReferenceBranchedConfig.Notify):

        notifications = [
            rm_notifications.Notification(
                event_type="KpiAlert",
                chat_name="scraper_over_yt_support::telegram",  # configurable in UI
                conditions=rm_notifications.CONDITION_ALWAYS,
            )
        ]

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "i024"
            queue = "SOYRELEASES"
            dev_queue = "SCRAPEROVERYT"
            summary_template = u"Priemka scraper_over_yt {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "i024",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "JandeksPoisk/KachestvoPoiska/scraper_over_yt/changelogs/"
        dirs = [
            "arcadia/search/scraper_over_yt",
            "arcadia/alice/uniproxy/mapper"
        ]
        review_groups = [
            "i024",
            "mvel",
            "saku",
            "coffeeman"
        ]
