# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core.jg import base as jg_base
from sandbox.projects.release_machine.components.config_core.jg import cube as jg_cube
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import build as build_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import release as release_cubes
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri


class SetraceCfg(configs.ReferenceCIConfig):
    name = "setrace"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="setrace"),
        login="redotter",
    )

    class CI(configs.ReferenceCIConfig.CI):
        """CI configuration"""
        a_yaml_dir = "search/tools/setrace"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "SEARCH-RELEASERS"
        grant_config_update_permissions_to_release_machine_robot = False

    class JG(jg_base.BaseReleaseMachineJobGraph):
        """Job graph"""

        @jg_flow.release_flow()
        def release(self):
            graph = super(self.__class__, self).release(self)
            main_graph_entry = graph.get(dummy_cubes.RMMainGraphEntry.NAME)

            build_backend = build_cubes.YaPackage2(
                packages=["search/tools/setrace/src/package.json"],
                resource_types=["SETRACE_BUNDLE"],
                needs=[main_graph_entry],
            )
            graph.add(build_backend)

            build_ui = jg_cube.base.Cube(
                name="build_ui",
                task="projects/setrace/build_setrace_ui",
                needs=[main_graph_entry],
            )
            graph.add(build_ui)

            release = release_cubes.ReleaseRmComponent2(
                component_name=self.component_name,
                where_to_release="stable",
                input=jg_cube.CubeInput(
                    component_resources={
                        "setrace_bundle": build_backend.output.resources["SETRACE_BUNDLE"].first().id,
                        "setrace_uibundle": build_ui.output.resources["SETRACE_UIBUNDLE"].first().id,
                    },
                    deploy_system=rm_const.DeploySystem.sandbox.name,
                ),
            )
            graph.add(release)

            return graph

    class Releases(configs.ReferenceCIConfig.Releases):
        """Releases configuration"""

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="setrace_bundle",
                    data=ri.SandboxResourceData("SETRACE_BUNDLE"),
                    deploy_infos=[
                        ri.single_nanny_service("production_setrace"),
                        ri.single_nanny_service("tracer"),
                        ri.single_nanny_service("tracer_alice"),
                        ri.single_nanny_service("tracer_zen"),
                    ]
                ),
                ri.ReleasableItem(
                    name="setrace_uibundle",
                    data=ri.SandboxResourceData("SETRACE_UIBUNDLE"),
                    deploy_infos=[
                        ri.single_nanny_service("production_setrace"),
                    ]
                ),
            ]

    class Notify(configs.ReferenceCIConfig.Notify):
        """Notifications configuration"""

        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "redotter"
            queue = "SETRACEREL"
            summary_template = u"Приемка Setrace {}"
            workflow = {}

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = ""
        dirs = [
            "arcadia/search/tools/setrace",
        ]

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        """Branches configuration"""
        start_version = 443  # first branch released using CI
