# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.components.configs.smart_devices import _branch_part as branch_part
from sandbox.projects.release_machine.components.configs.smart_devices import _release_part as release_part
from sandbox.projects.release_machine.components.configs.smart_devices._device_job_graph_base import DeviceJobGraphBase

import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class CentaurJobGraph(DeviceJobGraphBase):
    def __init__(self, platform, component_name, build_factory=False, create_new_gerrit_branch_on_prerelease=False,
                 rm_branch_name=None, is_factory_rm_branch=False):
        super(CentaurJobGraph, self).__init__(platform, component_name, create_new_gerrit_branch_on_prerelease,
                                              rm_branch_name, is_factory_rm_branch)
        self.build_factory = build_factory

    @property
    def image_build_types(self):
        # centaur has no image builds yet
        return []

    @property
    def release_groups(self):
        return ['beta']

    def get_all_build_variant_names(self):
        return [None]

    @property
    def branch_part(self):
        build_type_job_parameter = self.build_type_job_parameter('launcher', 'release', None)
        return [
            branch_part.BuildCentaurLauncherAppJob(
                job_name_parameter=build_type_job_parameter,
            ),
            branch_part.PublishApkToQuasmodromJob(
                job_name_parameter=build_type_job_parameter,
                job_arrows=(
                    jg_arrows.JobTrigger(
                        job_type=branch_part.BuildCentaurLauncherAppJob.JOB_TYPE,
                        job_name_parameter=build_type_job_parameter,
                        parent_job_data=(
                            jg_job_data.ParentDataDict(
                                input_key='tasklet_input',
                                dict_key='resource_id',
                                resource_name='QUASAR_CENTAUR_DEMO_APP',
                            ),
                        ),
                    ),
                ),
            ),
        ]

    def create_testing_release_part(self, platform_job_parameter, build_type_job_parameter):
        group_job_name_parameter = self.build_type_job_parameter('launcher', 'testing', None)
        return jg_release.JobGraphElementActionReleaseBase(
            job_name_parameter=group_job_name_parameter,
            job_params={
                "should_add_to_db": jg_utils.should_add_to_db_branch,
                "cancel_fallbehind_runs_on_fix": False,
            },
            job_arrows=(
                jg_arrows.JobTrigger(
                    job_type=branch_part.PublishApkToQuasmodromJob.JOB_TYPE,
                    job_name_parameter=build_type_job_parameter,
                ),
                jg_arrows.JobTrigger(
                    job_type=release_part.UpdateStartrekReleaseTicketJob.JOB_TYPE,
                    job_name_parameter=platform_job_parameter,
                )
            )
        )

    @property
    def release_part(self):
        jobs = []
        platform = 'centaur'
        is_critical = False
        comment = 'Update from centaur launcher job'
        platform_job_parameter = self.platform
        build_type_job_parameter = self.build_type_job_parameter('launcher', 'release', None)
        jobs.append(self.create_testing_release_part(platform_job_parameter, build_type_job_parameter))

        upload_symbols_arrows = []
        upload_symbols_job_name_parameter = 'CENTAUR_APP'
        jobs.append(release_part.UploadCentaurSymbolsJob(
            job_name_parameter=upload_symbols_job_name_parameter,
            build_centaur_app_job_name_parameter=build_type_job_parameter,
        ))
        upload_symbols_arrows.append(jg_arrows.JobTrigger(
            job_type=release_part.UploadCentaurSymbolsJob.JOB_TYPE,
            job_name_parameter=upload_symbols_job_name_parameter,
        ))

        for group in self.release_groups:
            group_job_name_parameter = self.build_type_job_parameter('launcher', group, None)
            jobs.append(jg_release.JobGraphElementActionReleaseBase(
                job_name_parameter=group_job_name_parameter,
                job_params={
                    "should_add_to_db": jg_utils.should_add_to_db_branch,
                    "cancel_fallbehind_runs_on_fix": False,
                },
                job_arrows=upload_symbols_arrows + [
                    jg_arrows.JobTrigger(
                        job_type=release_part.PublishApplicationUpdateToQuasmodromJob.JOB_TYPE,
                        job_name_parameter=group_job_name_parameter,
                    ),
                    jg_arrows.JobTrigger(
                        job_type=release_part.UpdateStartrekReleaseTicketJob.JOB_TYPE,
                        job_name_parameter=platform_job_parameter,
                    )
                ]
            ))

            jobs.append(
                release_part.PublishApplicationUpdateToQuasmodromJob(
                    platform=platform,
                    group_name=group,
                    is_critical=is_critical,
                    comment=comment,
                    job_name_parameter=group_job_name_parameter,
                    create_st_job_name_parameter=platform_job_parameter,
                    publish_apk_job_name_parameter=build_type_job_parameter
                )
            )

        jobs.extend((
            release_part.PlatformChangelogJob(
                self.platform,
                job_name_parameter=platform_job_parameter,
            ),
            release_part.CreateStartrekReleaseTicketJob(
                self.platform,
                job_name_parameter=platform_job_parameter,
                changelog_job_name_parameter=platform_job_parameter,
            ),
            release_part.UpdateStartrekReleaseTicketJob(
                self.platform,
                self.component_name,
                None,
                job_name_parameter=platform_job_parameter,
                create_st_job_name_parameter=self.platform,
                publish_apk_to_qd_job_name_parameter=build_type_job_parameter,
            ),
        ))

        return jobs
