from sandbox.common.format import ident

import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.stages.job_graph_element as jg_element

RESOURCE_TTL = 90


class ReleaseItemsNames(object):
    @staticmethod
    def daemons(platform):
        return 'QUASAR_{}_DAEMONS'.format(ident(platform))

    @staticmethod
    def factory_daemons(platform):
        return 'QUASAR_{}_FACTORY_DAEMONS'.format(ident(platform))

    @staticmethod
    def ota(platform):
        return 'QUASAR_{}_OTAIMAGE'.format(ident(platform))

    @staticmethod
    def app(platform):
        return 'QUASAR_{}_APP'.format(ident(platform))

    @staticmethod
    def tv_app(app_name):
        return 'ANDROID_TV_{}'.format(ident(app_name))


class JobDataToDict(jg_job_data.ParentDataDict):
    def __init__(self, input_key, dict_key, override=False):
        super(JobDataToDict, self).__init__(input_key, dict_key, None, override=override)


class JustPassDataToDict(JobDataToDict):
    def __init__(self, input_key, dict_key, value, override=False):
        super(JustPassDataToDict, self).__init__(input_key, dict_key, override)
        self.value = value

    def data(self, params, parent_job_name):
        return self.value


class ParentDataOutputToDict(JobDataToDict):
    def __init__(
            self, input_key, dict_key, output_key,
            override=False, transform=lambda x, params: x,
    ):
        super(ParentDataOutputToDict, self).__init__(input_key, dict_key, override=override)
        self.output_key = output_key
        self.transform = transform

    def data(self, params, parent_job_name):
        if self.output_key in params.parent_test_custom_fields[parent_job_name]:
            return self.transform(params.parent_test_custom_fields[parent_job_name][self.output_key], params)


class ParentDataCtxToDict(ParentDataOutputToDict):
    def data(self, params, parent_job_name):
        if self.output_key in params.parent_test_ctx[parent_job_name]:
            return self.transform(params.parent_test_ctx[parent_job_name][self.output_key], params)


class ParentDataResourceToDict(JobDataToDict):
    def __init__(
            self, input_key, dict_key, output_resource_name,
            override=False, transform=lambda x, params: x, many=False,
    ):
        super(ParentDataResourceToDict, self).__init__(input_key, dict_key, override=override)
        self.output_resource_name = output_resource_name
        self.transform = transform
        self.pass_many = many

    def data(self, params, parent_job_name):
        if self.output_resource_name in params.parent_test_resources[parent_job_name]:
            resources = params.parent_test_resources[parent_job_name][self.output_resource_name]
            if self.pass_many:
                return self.transform(resources, params)
            else:
                return self.transform(resources[0], params)


class BaseTaskletRunJob(jg_element.JobGraphElement):
    def __init__(
            self, tasklet_name, job_type, job_arrows,
            job_name_parameter="", job_params=None,
            frequency=jg_utils.TestFrequency.LAZY,
    ):
        merged_job_params = jg_utils.merge_job_params(
            job_params,
            dict(
                job_type=job_type,
                job_name_parameter=job_name_parameter,
                task_name='TASKLET_EXECUTOR',
                frequency=(frequency, None),
                should_add_to_db=jg_utils.should_add_to_db_branch,
                apiargs=dict(
                    hidden=False,
                ),
                ctx=dict(
                    resource_owner='QUASAR',
                    resource_type='SANDBOX_TASKS_BINARY',
                    resource_attrs=dict(
                        default_tasklet_name=tasklet_name,
                    ),
                    tasklet_name=tasklet_name,
                    yav_token_vault='QUASAR:robot-quasar-yav-token',
                ),
            ),
        )

        super(BaseTaskletRunJob, self).__init__(
            merged_job_params,
            job_arrows,
        )
