# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.components import configs as rm_configs
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.configs.smart_devices._pre_release_part as sd_prerelease
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
from sandbox.projects.release_machine.components.configs.smart_devices._smart_speaker_job_graph import SmartSpeakerJobGraph


class PlatformReleasesConfigBase(rm_configs.ReferenceBranchedConfig):
    name = None
    responsible = None

    class Notify(rm_configs.ReferenceBranchedConfig.Notify):
        """ Notifications configuration """

        class Mail(rm_configs.ReferenceBranchedConfig.Notify.Mail):
            """Mail notifications configuration"""
            mailing_list = [
                'quasar-dev@yandex-team.ru',
            ]

        class Startrek(rm_configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = None
            _branch_name = None
            followers = None

            @property
            def summary_template(self):
                return u'Отведение ветки {branch_name}/stable-{{}}'.format(branch_name=self._branch_name)

            @property
            def release_summary_template(self):
                return u'Релиз платформы {{}} из ветки {branch_name}/stable-{{}}'.format(branch_name=self._branch_name)

            queue = 'QUASAR'
            dev_queue = 'QUASAR'
            release_queue = 'ALICERELEASE'
            workflow = {}
            add_commiters_as_followers = False
            hide_commits_under_cut = True
            important_changes_limit = 1000

    class Releases(rm_configs.ReferenceBranchedConfig.Releases):
        allow_old_releases = True
        resources_info = None

    class ChangelogCfg(rm_configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = ''
        dirs = [
            'arcadia/yandex_io',
            'arcadia/smart_devices',
            'arcadia/speechkit',
            'arcadia/voicetech/vqe/yandex_vqe/yvqelib',
            'arcadia/voicetech/spotter/embedded',
        ]
        review_groups = [
            'yandex_io',
            'quasar-app',
        ]

    class SvnCfg(rm_configs.ReferenceBranchedConfig.SvnCfg):
        use_arc = True
        use_zipatch_only = True

    class Testenv(rm_configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_task_owner = 'QUASAR'

        _db_name = None

        @property
        def trunk_db(self):
            return '{db_name}-trunk'.format(db_name=self._db_name)

        @property
        def branch_db_template(self):
            return '{db_name}-{{testenv_db_num}}'.format(db_name=self._db_name)

        class JobGraph(rm_configs.ReferenceBranchedConfig.Testenv.JobGraph):
            device_job_graph = None

            @property
            def _prerelease(self):
                pre_release_part = [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(
                        ctx={"use_previous_branch_as_baseline": True}
                    ),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek()
                ]

                if self.device_job_graph.create_new_gerrit_branch_on_prerelease:
                    pre_release_part.append(
                        jg_prerelease.JobGraphElementActionPreReleaseStartrek(
                            use_arc=self._use_arc,
                            job_arrows=(
                                jg_arrows.JobTrigger(sd_prerelease.MergeSystemBranches.JOB_TYPE)
                            ),
                        )
                    )
                    pre_release_part.append(
                        sd_prerelease.CreateGerritBranch(
                            self.device_job_graph.platform,
                            self.device_job_graph.rm_branch_name,
                            self.device_job_graph.is_factory_rm_branch,
                        )
                    )
                    pre_release_part.append(
                        sd_prerelease.MergeSystemBranches(
                            component_name=self.name,
                            job_arrows=[
                                jg_arrows.JobTrigger(sd_prerelease.CreateGerritBranch.JOB_TYPE,
                                                     job_name_parameter=self.device_job_graph.platform)
                            ]
                        )
                    )
                else:
                    pre_release_part.append(
                        jg_prerelease.JobGraphElementActionPreReleaseStartrek(use_arc=self._use_arc)
                    )

                return pre_release_part

            @property
            def _branch_part(self):
                branch_part = super(PlatformReleasesConfigBase.Testenv.JobGraph, self)._branch_part

                branch_part.extend(SmartSpeakerJobGraph.common_branch_part())

                branch_part.extend(self.device_job_graph.branch_part)

                return branch_part

            @property
            def _release(self):
                release = [jg_release.JobGraphElementNewTag()]

                release.extend(self.device_job_graph.release_part)

                return release

        @staticmethod
        def db_drop_range(branch_number):
            # do not drop anything
            return []
