import sandbox.projects.release_machine.components.job_graph.stages.job_graph_element as jg_element
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_job_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers

from sandbox.projects.quasar.platform import get_platform_path_key


class CreateGerritBranch(jg_element.JobGraphElement):
    JOB_TYPE = 'CREATE_GERRIT_BRANCH'
    REPOSITORY_JSON_PATH = 'arcadia:/arc/trunk/arcadia/smart_devices/platforms/{}/firmware'

    def __init__(self, platform, rm_branch_name=None, is_factory_rm_branch=False):
        repository_path = self.REPOSITORY_JSON_PATH.format(get_platform_path_key(platform))

        ctx=dict(
            resource_owner='QUASAR',
            yav_token_vault='QUASAR:robot-quasar-yav-token',
            platform=platform,
            repository_config_url=repository_path,
            ssh_user='robot-quasar',
            ssh_key_vault_owner='QUASAR',
            ssh_key_vault_name='robot-quasar-ssh-private-key',
        )

        if rm_branch_name is not None:
            ctx['arcadia_release_branch_name'] = rm_branch_name

        if is_factory_rm_branch:
            ctx['gerrit_release_branch_prefix'] = 'factory-'
            ctx['keep_last_x_branches'] = 3
        else:
            ctx['keep_last_x_branches'] = 5

        job_params = dict(
            job_type=self.JOB_TYPE,
            task_name=self.JOB_TYPE,
            job_name_parameter=platform,
            should_add_to_db=jg_utils.should_add_to_db_trunk,
            apiargs=dict(
                hidden=False,
            ),
            ctx=ctx,
        )
        super(CreateGerritBranch, self).__init__(
            job_params=job_params,
            job_arrows=(
                jg_job_triggers.JobTriggerNewBranch([
                    jg_job_data.ParentDataOutput('arcadia_release_branch_number', 'new_branch_number'),
                ]),
            )
        )


class MergeSystemBranches(jg_element.JobGraphElement):
    JOB_TYPE = 'MERGE_TO_STABLE'
    REVISIONS = 'revs'

    def __init__(self, component_name, job_arrows):
        job_params = dict(
            job_type=self.JOB_TYPE,
            task_name=self.JOB_TYPE,
            should_add_to_db=jg_utils.should_add_to_db_trunk,
            apiargs=dict(
                hidden=False,
            ),
            ctx=dict(
                resource_owner='QUASAR',
                yav_token_vault='QUASAR:robot-quasar-yav-token',
                component_name=component_name
            ),
        )

        triggers = []
        for arrow in job_arrows:
            arrow.parent_job_data = (
                jg_job_data.ParentDataOutput("rev_{}".format(arrow.job_name_parameter), 'revision'),
            )
            triggers.append(arrow)

        super(MergeSystemBranches, self).__init__(
            job_params=job_params,
            job_arrows=[
                jg_job_arrows.ParentsData(
                    input_key=self.REVISIONS,
                    triggers=triggers,
                    transform=lambda **kwargs: ",".join(map(str, kwargs.values())),
                ),
                jg_job_triggers.JobTriggerNewBranch([
                    jg_job_data.ParentDataOutput('branch_nums_to_merge', 'new_branch_number'),
                ])
            ]
        )
