# -*- coding: utf-8 -*-

from sandbox.projects.quasar.build_types import ImageBuildtype, TvAppsBuildType

from sandbox.projects.release_machine.core import const as rm_const

from sandbox.projects.release_machine.components.configs.smart_devices import _branch_part as branch_part
from sandbox.projects.release_machine.components.configs.smart_devices import _release_part as release_part
from sandbox.projects.release_machine.components.configs.smart_devices import _tv_apps_job_graph as tv_apps_jg
from sandbox.projects.release_machine.components.configs.smart_devices._device_job_graph_base import DeviceJobGraphBase


class TvJobGraph(DeviceJobGraphBase):
    APPS_BUILD_TYPE_DICT = {
        ImageBuildtype.USER: TvAppsBuildType.RELEASE,
        ImageBuildtype.USERDEBUG: TvAppsBuildType.QA,
        ImageBuildtype.ENGINEERING: TvAppsBuildType.DEBUG,
    }

    def __init__(self, platform, component_name, build_factory=False, create_new_gerrit_branch_on_prerelease=False,
                 rm_branch_name=None, is_factory_rm_branch=False, use_rm_app_builds=False, has_regress=False):
        super(TvJobGraph, self).__init__(platform, component_name, create_new_gerrit_branch_on_prerelease,
                                         rm_branch_name, is_factory_rm_branch)
        self.build_factory = build_factory
        self.use_rm_app_build = use_rm_app_builds
        self.has_regress = has_regress

    @property
    def image_build_types(self):
        return [ImageBuildtype.USER, ImageBuildtype.USERDEBUG, ImageBuildtype.ENGINEERING]

    @property
    def image_build_type_to_release(self):
        return ImageBuildtype.USER

    def get_apps_build_types(self, image_build_type):
        return (self.APPS_BUILD_TYPE_DICT[image_build_type],)

    def apps_build_type_to_release(self, stage):
        return TvAppsBuildType.RELEASE

    @property
    def branch_part(self):
        jobs = []

        for revision in self.platform_revisions:
            for image_build_type in self.image_build_types:
                for apps_build_type in self.get_apps_build_types(image_build_type):
                    build_type_job_parameter = self.build_type_job_parameter(
                        image_build_type, apps_build_type, revision)

                    jobs.extend((
                        branch_part.BuildTVImageJob(
                            self.platform, revision,
                            sign=True, factory=self.build_factory,
                            build_type=image_build_type,
                            apps_build_type=apps_build_type,
                            job_name_parameter=build_type_job_parameter,
                            apps_job_arrows=self.get_apps_job_arrows(apps_build_type),
                        ),
                        branch_part.PublishImageToS3Job(
                            self.platform,
                            resource_filters=dict(signed='True'),
                            job_name_parameter=build_type_job_parameter,
                            build_image_job_name_parameter=build_type_job_parameter,
                        ),
                        branch_part.PublishImageToQuasmodromJob(
                            self.platform,
                            job_name_parameter=build_type_job_parameter,
                            publish_to_s3_job_name_parameter=build_type_job_parameter,
                        ),
                    ))

        return jobs

    @property
    def release_part(self):
        jobs = self.create_common_release_part(upload_symbols=True, has_regress=self.has_regress)

        release_stages = [
            rm_const.ReleaseStatus.testing,
            rm_const.ReleaseStatus.prestable,
            rm_const.ReleaseStatus.stable,
        ]

        for revision in self.platform_revisions:
            for stage in release_stages:
                release_build_type_parameter = self.build_type_job_parameter(
                    self.image_build_type_to_release,
                    self.apps_build_type_to_release(stage),
                    revision
                )
                jobs.append(release_part.ReleaseResourcesJob(
                    self.platform, stage, revision,
                    build_image_job_name_parameter=release_build_type_parameter,
                ))

        return jobs

    def create_upload_symbols_jobs(self):
        # dont create new jobs, just reference jobs from TvAppsJobGraph
        upload_symbols_parameters = [
            tv_apps_jg.TvAppsJobGraph.upload_symbols_job_name_parameter(app_name)
            for app_name, app_config in tv_apps_jg.APPS.items()
            if app_config.upload_symbols
        ]

        return [], upload_symbols_parameters

    def get_apps_job_arrows(self, apps_build_type):
        if not self.use_rm_app_build:
            return None

        return tv_apps_jg.get_apps_job_arrows('artifact_downloader_dependencies_json', self.platform, apps_build_type)
