# -*- coding: utf-8 -*-


from sandbox.projects.release_machine.components import configs as rm_configs
from sandbox.projects.release_machine.components.config_core.jg import base as jg_base
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow
from sandbox.projects.release_machine.components.config_core.jg import cube as jg_cube
from sandbox.projects.release_machine.components.config_core.jg.graph import base as jg_graph
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import internal as internal_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import testenv as testenv_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import smart_devices as smart_devices_cubes
from sandbox.projects.release_machine.components.config_core.jg.lib.conditions import ci_conditions

from sandbox.projects.release_machine.components.configs.smart_devices import smart_devices as orig_config_module


ORIGINAL_COMPONENT = orig_config_module.SmartDevicesConfig.name
LTS_BRANCHES = orig_config_module.LTS_BRANCHES


class SmartDevicesCiCfg(rm_configs.ReferenceCIConfig):
    """
    This is a CI-based clone of the smart_devices component. We're moving release logic from smart_devices to
    smart_devices_ci, baby steps
    """

    name = "{}_ci".format(ORIGINAL_COMPONENT)
    display_name = "Smart Devices"
    responsible = rm_configs.Responsible(
        abc=rm_configs.Abc(service_name="vsdev"),
        login="vreutov",
    )

    class CI(rm_configs.ReferenceCIConfig.CI):
        a_yaml_dir = "smart_devices/release_machine_ci"    # path to a.yaml directory (relative to Arcadia root)
        secret = "sec-01desry8fbgvnkbeybem81ferv"   # YaV secret
        sb_owner_group = "QUASAR"                   # Sandbox task owner group

        ya_make_abs_paths_glob = [  # These paths are used for commit graph discovery
            'yandex_io/**',
            'smart_devices/**',
            'speechkit/**',
            'voicetech/vqe/yandex_vqe/yvqelib/**',
            'voicetech/spotter/embedded/**',
        ]

    class JG(jg_base.BaseReleaseMachineJobGraph):

        def _add_gerrit_subgraph_cubes(self, graph):
            gerrit_branch_cubes = []

            new_branch_number = graph.get(internal_cubes.CreateSvnBranch.NAME).output_params.new_branch_number

            for sdjg_config in orig_config_module.SMART_DEVICES_JOB_GRAPHS:

                if not sdjg_config.create_new_gerrit_branch_on_prerelease:
                    continue

                gerrit_cube = smart_devices_cubes.CreateGerritBranchCube(
                    platform=sdjg_config.platform,
                    arcadia_release_branch_number=new_branch_number,
                    rm_branch_name=sdjg_config.rm_branch_name,
                    is_factory_rm_branch=sdjg_config.is_factory_rm_branch,
                    condition=ci_conditions.CI_FIRST_TAG_ONLY,
                )

                gerrit_branch_cubes.append(gerrit_cube)

                graph.add(gerrit_cube)

            merge_cube = smart_devices_cubes.MergeSystemBranchesCube(
                component_name=self.component_name,
                new_branch_number=new_branch_number,
                revisions=[cube.output_params.revision for cube in gerrit_branch_cubes],
                needs=gerrit_branch_cubes,
                condition=ci_conditions.CI_FIRST_TAG_ONLY,
            )

            graph.add(merge_cube)

        @jg_flow.release_flow()
        def release(self):

            new_tag = internal_cubes.NewTagCube(
                component_name=ORIGINAL_COMPONENT,
            )

            create_svn_branch = internal_cubes.CreateSvnBranch(
                component_name=ORIGINAL_COMPONENT,
                input=jg_cube.CubeInput(
                    custom_branch_number="${context.version_info.major}",
                    revision_for_trunk="${context.target_revision.number}",
                ),
                condition=ci_conditions.CI_FIRST_TAG_ONLY,
                needs=[new_tag],
            )

            pre_release_entry = dummy_cubes.Dummy(
                name="pre_release_entry",
                needs=[create_svn_branch],
                condition=ci_conditions.CI_FIRST_TAG_ONLY,
            )

            clone_te_db = testenv_cubes.CloneTestenvDb(
                component_name=ORIGINAL_COMPONENT,
                input=jg_cube.CubeInput(
                    branch_path=create_svn_branch.output_params.result_path,
                    start_revision=create_svn_branch.output_params.result_revision,
                    autostart_db=True,
                ),
                condition=ci_conditions.CI_FIRST_TAG_ONLY,
                needs=[pre_release_entry],
            )

            changelog = self._get_changelog_cube(
                candidate_path=create_svn_branch.output_params.result_path,
                needs=[pre_release_entry],
                use_previous_branch_as_baseline=True,
            )

            graph = jg_graph.Graph([new_tag, create_svn_branch, pre_release_entry, clone_te_db, changelog])

            self._add_startrek_jobs_if_required(graph, entry_cube_name=pre_release_entry.name)

            self._add_gerrit_subgraph_cubes(graph)

            pre_release_finish = dummy_cubes.Dummy(
                name="pre_release_finish",
                needs=graph.all_cubes_list,
                condition=ci_conditions.CI_FIRST_TAG_ONLY,
            )

            graph.add(pre_release_finish)

            return graph

    class MergesCfg(rm_configs.ReferenceBranchedConfig.MergesCfg):
        @property
        def lts_branches(self):
            return LTS_BRANCHES

    class Notify(rm_configs.ReferenceCIConfig.Notify):

        class Mail(rm_configs.ReferenceBranchedConfig.Notify.Mail):
            mailing_list = [
                'quasar-dev@yandex-team.ru',
            ]

        class Startrek(rm_configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = 'grmammaev'
            queue = 'QUASAR'
            dev_queue = 'QUASAR'
            release_queue = 'ALICERELEASE'
            summary_template = u'Отведение ветки smart_devices/stable-{}'
            release_summary_template = u'Релиз платформы {} из ветки smart_devices/stable-{}'
            workflow = {}
            followers = [
                'orinichev'
            ]
            add_commiters_as_followers = False
            hide_commits_under_cut = True
            important_changes_limit = 1000

    class ChangelogCfg(rm_configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = ''
        dirs = [
            'arcadia/yandex_io',
            'arcadia/smart_devices',
            'arcadia/speechkit',
            'arcadia/voicetech/vqe/yandex_vqe/yvqelib',
            'arcadia/voicetech/spotter/embedded',
        ]
        review_groups = [
            'yandex_io',
            'quasar-app',
        ]

    # Leaving it empty for now since we're leaving all release logic at smart_devices at the time
    class Releases(rm_configs.ReferenceCIConfig.Releases):
        resources_info = []

    class SvnCfg(rm_configs.ReferenceCIConfig.SvnCfg):

        start_version = 96  # Moved to the CI since 95th branch
        use_zipatch_only = True

        def __init__(self, *args, **kwargs):
            super(self.__class__, self).__init__(ORIGINAL_COMPONENT)
