# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.components.configs.smart_devices._platform_release_base as platform_release_base

from sandbox.projects.quasar.build_types import YandexmicroBuildrootImageBuildType
from sandbox.projects.quasar.platform import Platform
from sandbox.projects.release_machine.components.configs.smart_devices._smart_speaker_job_graph import SmartSpeakerJobGraph
from sandbox.projects.release_machine.core import const as rm_const


class YandexMicroFactoryJobGraph(SmartSpeakerJobGraph):
    def __init__(self):
        super(YandexMicroFactoryJobGraph, self).__init__(
            Platform.YANDEXMICRO,
            component_name=rm_const.RMNames.YANDEXMICRO_FACTORY,
            rm_branch_name=rm_const.RMNames.YANDEXMICRO_FACTORY,
            create_new_gerrit_branch_on_prerelease=True,
            is_factory_rm_branch=True
        )

    @property
    def image_build_types(self):
        return [
            YandexmicroBuildrootImageBuildType.USER,
            YandexmicroBuildrootImageBuildType.ENG,
            YandexmicroBuildrootImageBuildType.SL_LINUX
        ]

    @property
    def ota_build_types(self):
        return [
            YandexmicroBuildrootImageBuildType.ENG,
            YandexmicroBuildrootImageBuildType.USER
        ]

    @property
    def release_stages_of_groups(self):
        return {}

    @property
    def image_build_type_to_release(self):
        return YandexmicroBuildrootImageBuildType.USER


DEVICE_JOB_GRAPH = YandexMicroFactoryJobGraph()


class YandexMicroFactoryConfig(platform_release_base.PlatformReleasesConfigBase):
    name = rm_const.RMNames.YANDEXMICRO_FACTORY
    responsible = 'eninng'

    class Notify(platform_release_base.PlatformReleasesConfigBase.Notify):
        class Startrek(platform_release_base.PlatformReleasesConfigBase.Notify.Startrek):
            assignee = 'grmammaev'
            _branch_name = 'yandexmicro_factory'
            followers = [
                'orinichev',
                'vasko',
                'klio',
                'dmitrii-ut',
                'eninng'
            ]

    class Releases(platform_release_base.PlatformReleasesConfigBase.Releases):
        resources_info = DEVICE_JOB_GRAPH.release_items

    class Testenv(platform_release_base.PlatformReleasesConfigBase.Testenv):
        _db_name = 'yandexmicro-factory'

        class JobGraph(platform_release_base.PlatformReleasesConfigBase.Testenv.JobGraph):
            device_job_graph = DEVICE_JOB_GRAPH
