# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.components.configs.smart_devices._platform_release_base as platform_release_base

from sandbox.projects.quasar.build_types import YandexmidiBuildrootImageBuildType
from sandbox.projects.quasar.platform import Platform
from sandbox.projects.release_machine.components.configs.smart_devices._smart_speaker_job_graph import SmartSpeakerJobGraph
from sandbox.projects.release_machine.core import const as rm_const


class YandexMidiFactoryJobGraph(SmartSpeakerJobGraph):
    def __init__(self):
        super(YandexMidiFactoryJobGraph, self).__init__(
            Platform.YANDEXMIDI,
            component_name=rm_const.RMNames.YANDEXMIDI_FACTORY,
            rm_branch_name=rm_const.RMNames.YANDEXMIDI_FACTORY,
            create_new_gerrit_branch_on_prerelease=True,
            is_factory_rm_branch=True
        )

    @property
    def image_build_types(self):
        return [
            YandexmidiBuildrootImageBuildType.SL_LINUX,
            YandexmidiBuildrootImageBuildType.USER,
            YandexmidiBuildrootImageBuildType.ENG
        ]

    @property
    def ota_build_types(self):
        return [
            YandexmidiBuildrootImageBuildType.USER
        ]

    @property
    def release_stages_of_groups(self):
        return {
            'beta': rm_const.ReleaseStatus.prestable,
            'default': rm_const.ReleaseStatus.stable,
        }

    @property
    def image_build_type_to_release(self):
        return YandexmidiBuildrootImageBuildType.USER


DEVICE_JOB_GRAPH = YandexMidiFactoryJobGraph()


class YandexMidiFactoryConfig(platform_release_base.PlatformReleasesConfigBase):
    name = rm_const.RMNames.YANDEXMIDI_FACTORY
    responsible = 'grmammaev'

    class Notify(platform_release_base.PlatformReleasesConfigBase.Notify):
        class Startrek(platform_release_base.PlatformReleasesConfigBase.Notify.Startrek):
            assignee = 'grmammaev'
            _branch_name = 'yandexmidi_factory'
            followers = [
                'orinichev',
                'superbereza',
                "slavashel",
            ]

    class Releases(platform_release_base.PlatformReleasesConfigBase.Releases):
        resources_info = DEVICE_JOB_GRAPH.release_items

    class Testenv(platform_release_base.PlatformReleasesConfigBase.Testenv):
        _db_name = 'yandexmidi-factory'

        class JobGraph(platform_release_base.PlatformReleasesConfigBase.Testenv.JobGraph):
            device_job_graph = DEVICE_JOB_GRAPH
