# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.components.configs.smart_devices._platform_release_base as platform_release_base

from sandbox.projects.quasar.build_types import Yandexmini2BuildrootImageBuildType
from sandbox.projects.quasar.platform import Platform
from sandbox.projects.release_machine.components.configs.smart_devices._smart_speaker_job_graph import SmartSpeakerJobGraph
from sandbox.projects.release_machine.core import const as rm_const


class YandexMini2FactoryJobGraph(SmartSpeakerJobGraph):
    def __init__(self):
        super(YandexMini2FactoryJobGraph, self).__init__(
            Platform.YANDEXMINI_2,
            component_name=rm_const.RMNames.YANDEXMINI_2_FACTORY,
            rm_branch_name=rm_const.RMNames.YANDEXMINI_2_FACTORY,
            create_new_gerrit_branch_on_prerelease=True,
            is_factory_rm_branch=True
        )

    @property
    def image_build_types(self):
        return [
            Yandexmini2BuildrootImageBuildType.FACTORY,
            Yandexmini2BuildrootImageBuildType.SL_LINUX,
            Yandexmini2BuildrootImageBuildType.USER,
            Yandexmini2BuildrootImageBuildType.HW_TEST
        ]

    @property
    def ota_build_types(self):
        return [
            Yandexmini2BuildrootImageBuildType.FACTORY,
            Yandexmini2BuildrootImageBuildType.USER
        ]

    @property
    def release_stages_of_groups(self):
        return {}

    @property
    def image_build_type_to_release(self):
        return Yandexmini2BuildrootImageBuildType.FACTORY


DEVICE_JOB_GRAPH = YandexMini2FactoryJobGraph()


class YandexMini2FactoryConfig(platform_release_base.PlatformReleasesConfigBase):
    name = rm_const.RMNames.YANDEXMINI_2_FACTORY
    responsible = 'vasko'

    class Notify(platform_release_base.PlatformReleasesConfigBase.Notify):
        class Startrek(platform_release_base.PlatformReleasesConfigBase.Notify.Startrek):
            assignee = 'grmammaev'
            _branch_name = 'yandexmini_2_factory'
            followers = [
                'orinichev',
                'vasko',
                'klio'
            ]

    class Releases(platform_release_base.PlatformReleasesConfigBase.Releases):
        resources_info = DEVICE_JOB_GRAPH.release_items

    class Testenv(platform_release_base.PlatformReleasesConfigBase.Testenv):
        _db_name = 'yandexmini-2-factory'

        class JobGraph(platform_release_base.PlatformReleasesConfigBase.Testenv.JobGraph):
            device_job_graph = DEVICE_JOB_GRAPH
