# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.components.configs.smart_devices._platform_release_base as platform_release_base

from sandbox.projects.quasar.build_types import TvAppsBuildType, ImageBuildtype
from sandbox.projects.quasar.platform import Platform
from sandbox.projects.release_machine.components.configs.smart_devices._tv_job_graph import TvJobGraph
from sandbox.projects.release_machine.core import const as rm_const


TESTENV_DB_NAME = 'yandexmodule-2-factory'
RELEASE_BRANCH_NAME = 'yandexmodule_2_factory'


class YandexModule2FactoryJobGraph(TvJobGraph):
    def __init__(self):
        super(YandexModule2FactoryJobGraph, self).__init__(
            Platform.YANDEXMODULE_2,
            build_factory=True,
            create_new_gerrit_branch_on_prerelease=True,
            component_name=rm_const.RMNames.YANDEXMODULE_2_FACTORY,
            rm_branch_name=RELEASE_BRANCH_NAME,
            is_factory_rm_branch=True,
        )

    @property
    def image_build_types(self):
        return [
            ImageBuildtype.USER,
            ImageBuildtype.ENGINEERING,
        ]

    def get_apps_build_types(self, image_build_type):
        if image_build_type == ImageBuildtype.USER:
            return [TvAppsBuildType.RELEASE, TvAppsBuildType.PRESTABLE]
        else:
            return [TvAppsBuildType.DEBUG]

    @property
    def release_stages_of_groups(self):
        return {}

    @property
    def image_build_type_to_release(self):
        return ImageBuildtype.USER

    def apps_build_type_to_release(self, stage):
        if stage == rm_const.ReleaseStatus.stable:
            return TvAppsBuildType.RELEASE
        else:
            return TvAppsBuildType.PRESTABLE


DEVICE_JOB_GRAPH = YandexModule2FactoryJobGraph()


class YandexModule2FactoryConfig(platform_release_base.PlatformReleasesConfigBase):
    name = rm_const.RMNames.YANDEXMODULE_2_FACTORY
    responsible = 'grmammaev'

    class Notify(platform_release_base.PlatformReleasesConfigBase.Notify):
        class Startrek(platform_release_base.PlatformReleasesConfigBase.Notify.Startrek):
            assignee = 'grmammaev'
            _branch_name = RELEASE_BRANCH_NAME
            followers = [
                'orinichev',
                'poroshin-ivan',
                'pupssman',
            ]

    class Releases(platform_release_base.PlatformReleasesConfigBase.Releases):
        resources_info = DEVICE_JOB_GRAPH.release_items

    class Testenv(platform_release_base.PlatformReleasesConfigBase.Testenv):
        _db_name = TESTENV_DB_NAME

        class JobGraph(platform_release_base.PlatformReleasesConfigBase.Testenv.JobGraph):
            device_job_graph = DEVICE_JOB_GRAPH
