# -*- coding: utf-8 -*-

import collections

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.config_core.jg.cube import base as jg_cube
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import release as release_cubes
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets

SMELTER_TESTING_WORKER_PROCESSOR = "smelter-testing-worker-processor"
SMELTER_TESTING_STARTER_WORKER_PROCESSOR = "smelter-testing-starter-worker-processor"
SMELTER_TESTING_STARTER = "smelter-testing-starter"

SMELTER_PRODUCTION_WORKER_PROCESSOR = "smelter-production-worker-processor"
SMELTER_PRODUCTION_STARTER_WORKER_PROCESSOR = "smelter-production-starter-worker-processor"
SMELTER_PRODUCTION_WORKER_RESHARDER = "smelter-production-worker-resharder"
SMELTER_PRODUCTION_STARTER = "smelter-production-starter"
SMELTER_PRODUCTION_ML_WORKER = "smelter-production-ml-worker"
SMELTER_PRODUCTION_BERT_RELEVANCE = "smelter-production-search-bert-relevance"
SMELTER_PRODUCTION_TOLOKA_WORKER = "smelter-production-toloka-worker"
SMELTER_PRODUCTION_BACKEND = "smelter-production-backend"


def get_service_short_name(service_name):
    PREFIX = "smelter-production-"
    if service_name.startswith(PREFIX):
        service_name = service_name[len(PREFIX):]

    return service_name.replace("-", "_")


class SmelterCfg(configs.ReferenceCIConfig):
    name = "smelter"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="smelter"),
        login="niknik",
    )
    robot = "robot-smelter"

    class JG(basic_build_presets.SingleBuildYaPackageJGCfg):
        def _get_build_cube(self, graph):
            build = super(self.__class__, self)._get_build_cube(graph)
            build.input.update(raw_package=True)  # do not tarball, so we don't have to unpack it in nanny
            return build

        def _get_release_cubes(self, graph, build):
            ri_by_service = collections.defaultdict(lambda: collections.defaultdict(lambda: collections.defaultdict(list)))

            for deploy_system, where, releasable_items in (
                self._iter_over_releasable_items_with_release_stages_and_deploy_systems(build)
            ):
                for releasable_item in releasable_items:
                    for di in releasable_item.deploy_infos:
                        for service in di.services:
                            ri_by_service[deploy_system][where][service.name].append(releasable_item)

            result = []
            for deploy_system, inner_dict1 in ri_by_service.items():
                for where, inner_dict2 in inner_dict1.items():
                    for service, releasable_items in inner_dict2.items():
                        result.extend(
                            self._get_release_cubes_for_deploy_system(deploy_system, where, service, releasable_items, graph, build)
                        )

            return result

        def _get_release_cubes_for_deploy_system(self, deploy_system, where, service, releasable_items, graph, build):
            return [
                release_cubes.ReleaseRmComponent2(
                    name="release_{}_{}_{}".format(get_service_short_name(service), where, deploy_system),
                    component_name=self.component_name,
                    task=self.release_task,
                    where_to_release=where,
                    input=jg_cube.CubeInput(
                        component_resources={
                            ri.name: build.output.resources[ri.data.resource_type].first().id
                            for ri in releasable_items
                        },
                        deploy_system=deploy_system,
                    ),
                    manual=self.release_manually,
                )
            ]

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "robot/smelter"
        secret = "sec-01fyxfd2pxc0dwyadfb0jhb6ga"  # robot-smelter secret (when token redelegation problem is solved we can return to RM secret)
        sb_owner_group = "SMELTER"

        # влюкчаем graph- и dir-discovery по этим путям
        ya_make_abs_paths_glob = [
            "robot/smelter/**",
        ]

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="smelter_worker_processor",
                    data=ri.SandboxResourceData("SMELTER_WORKER_PROCESSOR", dst_path="worker"),
                    build_data=ri.BuildData(
                        target="robot/smelter/packages/worker_processor/pkg.json"
                    ),
                    deploy_infos=[
                        ri.single_nanny_service_push(SMELTER_PRODUCTION_WORKER_PROCESSOR),
                        ri.single_nanny_service_push(SMELTER_PRODUCTION_STARTER_WORKER_PROCESSOR)
                    ],
                ),
                ri.ReleasableItem(
                    name="smelter_worker_resharder",
                    data=ri.SandboxResourceData("SMELTER_WORKER_RESHARDER", dst_path="worker"),
                    build_data=ri.BuildData(
                        target="robot/smelter/packages/worker_resharder/pkg.json"
                    ),
                    deploy_infos=[
                        ri.single_nanny_service_push(SMELTER_PRODUCTION_WORKER_RESHARDER)
                    ],
                ),
                ri.ReleasableItem(
                    name="smelter_starter",
                    data=ri.SandboxResourceData("SMELTER_STARTER", dst_path="worker"),
                    build_data=ri.BuildData(
                        target="robot/smelter/packages/starter/pkg.json"
                    ),
                    deploy_infos=[
                        ri.single_nanny_service_push(SMELTER_PRODUCTION_STARTER)
                    ],
                ),
                ri.ReleasableItem(
                    name="smelter_ml_worker",
                    data=ri.SandboxResourceData("SMELTER_ML_WORKER", dst_path="worker"),
                    build_data=ri.BuildData(
                        target="robot/smelter/packages/ml_worker/pkg.json"
                    ),
                    deploy_infos=[
                        ri.single_nanny_service_push(SMELTER_PRODUCTION_ML_WORKER)
                    ],
                ),
                ri.ReleasableItem(
                    name="smelter_search_bert_relevance",
                    data=ri.SandboxResourceData("SMELTER_SEARCH_BERT_RELEVANCE", dst_path="worker"),
                    build_data=ri.BuildData(
                        target="robot/smelter/packages/search_bert_relevance/pkg.json"
                    ),
                    deploy_infos=[
                        ri.single_nanny_service_push(SMELTER_PRODUCTION_BERT_RELEVANCE)
                    ],
                ),
                ri.ReleasableItem(
                    name="smelter_toloka_worker",
                    data=ri.SandboxResourceData("SMELTER_TOLOKA_WORKER", dst_path="worker"),
                    build_data=ri.BuildData(
                        target="robot/smelter/packages/toloka_worker/pkg.json"
                    ),
                    deploy_infos=[
                        ri.single_nanny_service_push(SMELTER_PRODUCTION_TOLOKA_WORKER)
                    ],
                ),
                ri.ReleasableItem(
                    name="smelter_testing_configs",
                    data=ri.SandboxResourceData("SMELTER_TESTING_CONFIGS", dst_path="config"),
                    build_data=ri.BuildData(
                        target="robot/smelter/packages/testing_configs/pkg.json"
                    ),
                    deploy_infos=[
                        ri.single_nanny_service_push(SMELTER_TESTING_WORKER_PROCESSOR, stage="prestable"),
                        ri.single_nanny_service_push(SMELTER_TESTING_STARTER_WORKER_PROCESSOR, stage="prestable"),
                        ri.single_nanny_service_push(SMELTER_TESTING_STARTER, stage="prestable")
                    ],
                ),
                ri.ReleasableItem(
                    name="smelter_configs",
                    data=ri.SandboxResourceData("SMELTER_CONFIGS", dst_path="config"),
                    build_data=ri.BuildData(
                        target="robot/smelter/packages/configs/pkg.json"
                    ),
                    deploy_infos=[
                        ri.single_nanny_service_push(SMELTER_PRODUCTION_TOLOKA_WORKER),
                        ri.single_nanny_service_push(SMELTER_PRODUCTION_ML_WORKER),
                        ri.single_nanny_service_push(SMELTER_PRODUCTION_WORKER_PROCESSOR),
                        ri.single_nanny_service_push(SMELTER_PRODUCTION_STARTER_WORKER_PROCESSOR),
                        ri.single_nanny_service_push(SMELTER_PRODUCTION_WORKER_RESHARDER),
                        ri.single_nanny_service_push(SMELTER_PRODUCTION_BERT_RELEVANCE),
                        ri.single_nanny_service_push(SMELTER_PRODUCTION_STARTER)
                    ],
                ),
                ri.ReleasableItem(
                    name="smelter_logfetcher",
                    data=ri.SandboxResourceData("SMELTER_LOGFETCHER", dst_path="logfetcher"),
                    build_data=ri.BuildData(
                        target="robot/smelter/packages/logfetcher/pkg.json"
                    ),
                    deploy_infos=[
                        ri.single_nanny_service_push(SMELTER_PRODUCTION_TOLOKA_WORKER),
                        ri.single_nanny_service_push(SMELTER_PRODUCTION_ML_WORKER),
                        ri.single_nanny_service_push(SMELTER_PRODUCTION_WORKER_PROCESSOR),
                        ri.single_nanny_service_push(SMELTER_PRODUCTION_STARTER_WORKER_PROCESSOR),
                        ri.single_nanny_service_push(SMELTER_PRODUCTION_WORKER_RESHARDER),
                        ri.single_nanny_service_push(SMELTER_PRODUCTION_BERT_RELEVANCE),
                        ri.single_nanny_service_push(SMELTER_PRODUCTION_STARTER)
                    ],
                ),
                ri.ReleasableItem(
                    name="smelter_backend",
                    data=ri.SandboxResourceData("SMELTER_BACKEND", dst_path="backend"),
                    build_data=ri.BuildData(
                        target="robot/smelter/packages/backend/pkg.json"
                    ),
                    deploy_infos=[
                        ri.single_nanny_service_push(SMELTER_PRODUCTION_BACKEND)
                    ],
                ),
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceCIConfig.Notify):
        use_startrek = False  # можно стереть и добавить секцию Startrek, если нужны релизные тикеты

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = None
        dirs = [
            "robot/smelter",
        ]
