# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
import sandbox.projects.release_machine.core.const as rm_const
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers


SOCIALISM_STARTREK_COMPONENT = 4271
BACKEND_STARTREK_COMPONENT = 4280
# PASSP-25307
DISABLE_MYSQL_SSL_PATCH = "https://paste.yandex-team.ru/5141120/text"


class SocialCfgMixin(object):
    responsible = "andrey1931"


class SocialTestenvMixin(object):
    trunk_task_owner = "PASSPORT"

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        tag_prefix = ""
        branch_prefix = ""
        branch_folder_template = "{branch_prefix}{branch_num}"
        # tag_prefix пустой и нам не нужен, но он необходим в шаблоне
        tag_folder_template = "{branch_num}.{tag_num}{tag_prefix}"
        tag_folder_pattern = r"([0-9]+)\.([0-9]+)"


class SocialNotifyStartrekMixin(object):
    assignee = "robot-ironfelix"
    queue = "PASSP"
    dev_queue = "PASSP"
    ticket_type = "Release"
    workflow = {}
    followers = [
        "kmerenkov",
    ]
    components = [
        SOCIALISM_STARTREK_COMPONENT,
        BACKEND_STARTREK_COMPONENT,
    ]
    add_commiters_as_followers = False
    use_task_author_as_assignee = False
    nanny_reports = False
    deadline = None
    notify_on_release_to_release_st_ticket = False


class SocialJobGraphMixin(object):
    @property
    def social_package_name(self):
        raise NotImplementedError()

    @property
    def social_resource_name(self):
        raise NotImplementedError()

    @property
    def social_arcadia_patch(self):
        raise NotImplementedError()

    @property
    def social_debian_repo(self):
        raise NotImplementedError()

    @property
    def _branch_part(self):
        branch_part = super(SocialJobGraphMixin, self)._branch_part
        ctx = {
            # Социализм невозможно собрать с thinlto
            "thinlto": False,
            "run_tests": True,
            "run_medium_tests": True,
            "package_type": "debian",
            "publish_package": True,
            "publish_to_mapping": {
                self.social_package_name: self.social_debian_repo,
            },
        }
        if self.social_arcadia_patch:
            ctx.update({"arcadia_patch": self.social_arcadia_patch})
        branch_part.append(
            jg_build.JobGraphElementBuildPackageBranched(
                job_params={
                    "apiargs": {
                        "requirements": {
                            "disk_space": (10 << 30),
                        },
                    },
                },
                resource_names=self.social_resource_name,
                package_names=self.social_package_name,
                ctx=ctx,
                out={
                    self.social_resource_name: 30,
                },
            ),
        )
        return branch_part

    @property
    def _release(self):
        return super(SocialJobGraphMixin, self)._release + [
            jg_release.JobGraphElementWikiFinal(),
            jg_release.JobGraphElementReleaseBranched(
                release_to=rm_const.ReleaseStatus.stable,
                job_arrows=jg_job_triggers.JobTriggerBuild(
                    parent_job_data=(
                        jg_job_data.ParentDataDict(
                            "component_resources",
                            self.social_resource_name,
                            self.social_resource_name,
                        ),
                    ),
                ),
            ),
            jg_release.JobGraphElementActionReleaseBranched(
                release_to=rm_const.ReleaseStatus.stable,
                job_params={
                    "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                },
                job_arrows=jg_job_triggers.JobTriggerWikiFinal(),
            ),
        ]


class SocialReleasesMixin(object):
    allow_robots_to_release_stable = True

    @property
    def resources_info(self):
        return [
            configs.ReleasedResourceInfo(
                name=self.social_resource_name,
                resource_type=self.social_resource_name,
            ),
        ]

    @property
    def social_resource_name(self):
        raise NotImplementedError()
