# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.configs.socialism import _base


class SocialConfigsCfg(_base.SocialCfgMixin, configs.ReferenceBranchedConfig):
    name = "social_configs"

    class Testenv(_base.SocialTestenvMixin, configs.ReferenceBranchedConfig.Testenv):
        class JobGraph(_base.SocialJobGraphMixin, configs.ReferenceBranchedConfig.Testenv.JobGraph):
            social_package_name = "passport/backend/social/configs/deb/yandex-social-configs.json"
            social_resource_name = "SOCIAL_CONFIGS_PACKAGE"
            # Конфигурация не зависит от MySQL, поэтому ничего патчить
            # не надо
            social_arcadia_patch = None
            social_debian_repo = "passport"

    class Releases(_base.SocialReleasesMixin, configs.ReferenceBranchedConfig.Releases):
        social_resource_name = "SOCIAL_CONFIGS_PACKAGE"

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Startrek(_base.SocialNotifyStartrekMixin, configs.ReferenceBranchedConfig.Notify.Startrek):
            summary_template = u"Релиз yandex-social-configs {}"

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        dirs = [
            "arcadia/passport/backend/social/configs",
        ]
        wiki_page = "social/changelog/configs/"
