# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.configs.socialism import _base


class SocialNginxCfg(_base.SocialCfgMixin, configs.ReferenceBranchedConfig):
    name = "social_nginx"

    class Testenv(_base.SocialTestenvMixin, configs.ReferenceBranchedConfig.Testenv):
        class JobGraph(_base.SocialJobGraphMixin, configs.ReferenceBranchedConfig.Testenv.JobGraph):
            social_package_name = "passport/backend/social/nginx/yandex-social-nginx.json"
            social_resource_name = "SOCIAL_NGINX_PACKAGE"
            # Конфигурация Nginx не зависит от MySQL, поэтому ничего
            # патчить не надо
            social_arcadia_patch = None
            social_debian_repo = "passport-trusty"

    class Releases(_base.SocialReleasesMixin, configs.ReferenceBranchedConfig.Releases):
        social_resource_name = "SOCIAL_NGINX_PACKAGE"

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Startrek(_base.SocialNotifyStartrekMixin, configs.ReferenceBranchedConfig.Notify.Startrek):
            summary_template = u"Релиз yandex-social-nginx {}"

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        dirs = [
            "arcadia/passport/backend/social/nginx",
        ]
        wiki_page = "social/changelog/nginx/"
