# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.configs.socialism import _base


class SocialUtilsCfg(_base.SocialCfgMixin, configs.ReferenceBranchedConfig):
    name = "social_utils"

    class Testenv(_base.SocialTestenvMixin, configs.ReferenceBranchedConfig.Testenv):
        class JobGraph(_base.SocialJobGraphMixin, configs.ReferenceBranchedConfig.Testenv.JobGraph):
            social_package_name = "passport/backend/social/utils/deb/yandex-social-utils.json"
            social_resource_name = "SOCIAL_UTILS_PACKAGE"
            social_arcadia_patch = _base.DISABLE_MYSQL_SSL_PATCH
            social_debian_repo = "passport-trusty"

    class Releases(_base.SocialReleasesMixin, configs.ReferenceBranchedConfig.Releases):
        social_resource_name = "SOCIAL_UTILS_PACKAGE"

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Startrek(_base.SocialNotifyStartrekMixin, configs.ReferenceBranchedConfig.Notify.Startrek):
            summary_template = u"Релиз yandex-social-utils {}"

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        dirs = [
            "arcadia/passport/backend/social/utils",
            "arcadia/passport/backend/social/common",
            "arcadia/passport/backend/social/proxylib",
        ]
        wiki_page = "social/changelog/utils/"
