# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.configs.socialism import _base


class SocialUtilsDumpersCfg(_base.SocialCfgMixin, configs.ReferenceBranchedConfig):
    name = "social_utils_dumpers"

    class Testenv(_base.SocialTestenvMixin, configs.ReferenceBranchedConfig.Testenv):
        class JobGraph(_base.SocialJobGraphMixin, configs.ReferenceBranchedConfig.Testenv.JobGraph):
            social_package_name = "passport/backend/social/dumpers/deb/yandex-social-utils-dumpers.json"
            social_resource_name = "SOCIAL_UTILS_DUMPERS_PACKAGE"
            social_arcadia_patch = _base.DISABLE_MYSQL_SSL_PATCH
            social_debian_repo = "passport"

    class Releases(_base.SocialReleasesMixin, configs.ReferenceBranchedConfig.Releases):
        social_resource_name = "SOCIAL_UTILS_DUMPERS_PACKAGE"

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Startrek(_base.SocialNotifyStartrekMixin, configs.ReferenceBranchedConfig.Notify.Startrek):
            summary_template = u"Релиз yandex-social-utils-dumpers {}"

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        dirs = [
            "arcadia/passport/backend/social/dumpers",
            "arcadia/passport/backend/social/common",
        ]
        wiki_page = "social/changelog/utils_dumpers/"
