# -*- coding: utf-8 -*-
from six import iteritems

from sandbox.projects.common import constants as sandbox_constants
from sandbox.projects.release_machine.components import configs
import sandbox.projects.release_machine.core.const as rm_const
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows


targets = [
    {
        'desc': 'Feedback api server binary',
        'target': 'server/bin',
        'arts': 'feedback-api-server',
        'id': 'server_binary'
    },
    {
        'desc': 'Feedback api server configs',
        'target': 'server/configs',
        'id': 'server_configs'
    },
    {
        'desc': 'Feedback processor binary',
        'target': 'feedback_processor/bin',
        'id': 'processor_binary'
    },
    {
        'desc': 'Feedback processor configs',
        'target': 'feedback_processor/configs',
        'id': 'processor_configs'
    },
    {
        'desc': 'Feedback data proxy binaries',
        'target': 'ext_instruments/bin',
        'id': 'data_proxy_binaries'
    },
    {
        'desc': 'Feedback data proxy configs',
        'target': 'ext_instruments/configs',
        'id': 'data_proxy_configs'
    },
    {
        'desc': 'Geospam processor binaries',
        'target': 'geospam_processor/bin',
        'id': 'geospam_processor_binaries'
    },
    {
        'desc': 'Geospam processor configs',
        'target': 'geospam_processor/configs',
        'id': 'geospam_processor_configs'
    },
]


recipe_mapping = {
    rm_const.ReleaseStatus.prestable: 'deploy_rc',
    rm_const.ReleaseStatus.stable: 'deploy_prod'
}


def _get_resource(meta):
    return 'SPRAV_FEEDBACK_{}'.format(meta['id'].upper())


class SpravFeedbackCfg(configs.ReferenceBranchedConfig):
    name = "sprav_feedback"
    display_name = "Org Feedback"
    responsible = "outlander"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_task_owner = "ALTAY"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementActionPreReleaseBase(
                        job_arrows=(
                            jg_job_triggers.JobTriggerChangelog(),
                        ),
                    ),
                ]

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part

                for meta in targets:
                    arts_suffix = '{}/{}'.format(meta['target'], meta['arts']) if 'arts' in meta else meta['target']
                    branch_part.append(
                        jg_build.JobGraphElementYaMakeBuildBranched(
                            task_name='YA_MAKE_RELEASE_TO_NANNY',
                            build_item=meta['id'].upper(),
                            job_params={
                                'apiargs': {
                                    'requirements': {
                                        'disk_space': 50 << 30,  # 50 Gb
                                    },
                                },
                            },
                            ctx={
                                'targets': 'sprav/feedback/packages/{}'.format(meta['target']),
                                'arts': 'sprav/feedback/packages/{}'.format(arts_suffix),
                                'arts_source': '',
                                'result_rt': _get_resource(meta),
                                'result_rd': meta['desc'],
                                'result_single_file': True,
                                sandbox_constants.DEFINITION_FLAGS_KEY: '-DDEBUGINFO_LINES_ONLY=yes',
                                sandbox_constants.BUILD_SYSTEM_KEY: sandbox_constants.YMAKE_BUILD_SYSTEM,
                                sandbox_constants.YA_YT_DIR: '//home/altay/yamake_cache',
                                sandbox_constants.YA_YT_PROXY: 'arnold.yt.yandex.net',
                                sandbox_constants.YA_YT_PUT: True,
                                sandbox_constants.YA_YT_STORE: True,
                                sandbox_constants.YA_YT_TOKEN_VAULT_NAME: 'altay_db_yt_token',
                                sandbox_constants.YA_YT_TOKEN_VAULT_OWNER: 'ALTAY'
                            },
                            out={_get_resource(meta): 30},
                        )
                    )

                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="YA_MAKE_2",
                        build_item="ARCADIA_TESTS",
                        job_params={
                            "apiargs": {
                                "requirements": {
                                    'disk_space': 50 << 30,  # 50 Gb
                                },
                            },
                        },
                        ctx={
                            "targets": "sprav/feedback/packages/tests",
                            "clear_build": False,
                            "test": True,
                            "report_tests_only": True,
                            "disable_test_timeout": True,
                            "cache_test_results": False,
                            "tests_retries": 2,
                            sandbox_constants.DEFINITION_FLAGS_KEY: '-DDEBUGINFO_LINES_ONLY=yes',
                            sandbox_constants.BUILD_SYSTEM_KEY: sandbox_constants.YMAKE_BUILD_SYSTEM,
                            sandbox_constants.YA_YT_DIR: '//home/altay/yamake_cache',
                            sandbox_constants.YA_YT_PROXY: 'arnold.yt.yandex.net',
                            sandbox_constants.YA_YT_PUT: True,
                            sandbox_constants.YA_YT_STORE: True,
                            sandbox_constants.YA_YT_TOKEN_VAULT_NAME: 'altay_db_yt_token',
                            sandbox_constants.YA_YT_TOKEN_VAULT_OWNER: 'ALTAY'
                        },
                    )
                )

                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                triggers = []

                for meta in targets:
                    triggers.append(
                        jg_job_triggers.JobTriggerBuild(
                            job_name_parameter=meta['id'].upper(),
                            parent_job_data=(
                                jg_job_data.ParentDataId(
                                    input_key='{}_id'.format(meta['id']),
                                ),
                            ),
                        )
                    )

                for release_type, recipe in iteritems(recipe_mapping):
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            task_name='DEPLOY_NANNY_DASHBOARD_WITH_RESOURCES',
                            release_to=release_type,
                            release_item='DEPLOY_FEEDBACK_SERVICES',
                            job_arrows=(
                                jg_arrows.ParentsData(
                                    input_key="deployment_tasks",
                                    triggers=triggers,
                                    transform=lambda **data: data.values(),
                                )
                            ),
                            job_params={
                                'ctx': {
                                    'nanny_dashboard_id': 'sprav_feedback',
                                    'nanny_dashboard_recipe_id': recipe,
                                    'nanny_token_vault_id': 'feedback_nanny_token',
                                    'release_type': release_type,
                                    'poll_timeout': '120',
                                }
                            },

                        )
                    )

                    release_part.append(
                        jg_release.JobGraphElementActionReleaseBranched(
                            release_to=release_type,
                            release_item='DEPLOY_FEEDBACK_SERVICES'
                        )
                    )

                return release_part

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        resources_info = [
            configs.ReleasedResourceInfo(
                name='sprav_feedback_{}_resource_id'.format(meta['id']),
                resource_type=_get_resource(meta),
                deploy=[
                    configs.DeployServicesInfo(
                        services=['feedback-server-prod'],
                        level=rm_const.ReleaseStatus.stable
                    ),
                    configs.DeployServicesInfo(
                        services=['feedback-server-rc'],
                        level=rm_const.ReleaseStatus.prestable
                    )
                ] if meta['id'] == 'server_binary' else None
            ) for meta in targets
        ]

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""
        use_startrek = False

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = ""
        dirs = [
            "arcadia/sprav/feedback"
        ]
