# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets


class StageControllerCfg(configs.ReferenceCIConfig):
    name = "stage_controller"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="drug"),
        login="amich",
    )

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        start_version = 160

    class JG(basic_build_presets.SingleBuildYaPackageJGCfg):

        def _get_build_cube(self, graph):
            build = super(self.__class__, self)._get_build_cube(graph)
            build.attributes.update(requirements={"disk": "20GB"})
            return build

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "infra/stage_controller/daemon"
        secret = "sec-01desry8fbgvnkbeybem81ferv"  # это секрет RM; если очень нужно, то можно использовать свой
        sb_owner_group = "DRUG-RELEASERS"

        # влюкчаем graph- и dir-discovery по этим путям
        ya_make_abs_paths_glob = [
            "infra/stage_controller/daemon/**",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [ri.ReleasableItem(
                name="stage_controller_package",
                data=ri.SandboxResourceData("STAGE_CONTROLLER_PACKAGE", ttl=30),
                build_data=ri.BuildData(target="infra/stage_controller/daemon/pkg.json"),
                deploy_infos=[
                    ri.single_nanny_service("stage_controller_prod"),
                    ri.single_nanny_service("stage_controller_prestable", stage=rm_const.ReleaseStatus.prestable),
                ],
            )]

        release_followers_permanent = [
            "amich",
        ]
        allow_old_releases = True
        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceCIConfig.Notify):
        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "amich"
            queue = "STAGECTLREL"
            dev_queue = "DEPLOY"
            summary_template = u"Приемка stage_controller {}"
            workflow = {}
            followers = [
                "amich",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = "infra/stage_controller/releases/"
        observed_paths = [
            "arcadia/infra/stage_controller/daemon",
            "arcadia/infra/libs/java/controller",
            "arcadia/yp/yp_proto/yp/client/api/proto/stage.proto",
            "arcadia/yp/java/yp"
        ]
