# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.common import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class StokerCfg(configs.ReferenceTaggedConfig):
    name = "stoker"
    responsible = "lebedev-aa"

    class Releases(configs.ReferenceTaggedConfig.Releases):
        allow_old_releases = True
        allow_robots_to_release_stable = True
        resources_info = [
            configs.ReleasedResourceInfo(
                name="stoker",
                resource_type="STOKER_MODEL_BINARY",
                resource_name="stoker_binary_res_id",
                deploy=[(rm_const.ReleaseStatus.stable, "stoker")],
            )
        ]

    class SvnCfg(configs.ReferenceTaggedConfig.SvnCfg):
        tag_name = "stoker"
        tag_folder_template = r"{tag_prefix}{tag_num}"

    class Testenv(configs.ReferenceTaggedConfig.Testenv):
        trunk_db = "stoker-trunk"
        trunk_task_owner = "MAESTRO"

        class JobGraph(configs.ReferenceTaggedConfig.Testenv.JobGraph):
            @property
            def _tag_part(self):
                return [
                    jg_build.JobGraphElementBuildTagged(
                        task_name="BUILD_STOKER_YA",
                        job_params={
                            "observed_paths": ["search/stoker", "search/martylib"],
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        out={"STOKER_MODEL_BINARY": 40},
                        ctx={
                            sandbox_constants.TESTS_REQUESTED: True,
                        },
                    ),
                    jg_prerelease.JobGraphElementPreliminaryChangelogTagged(),
                ]

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_part.append(
                    jg_release.JobGraphElementNewTagTagged()
                )
                release_part.append(
                    jg_release.JobGraphElementReleaseTagged(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "stoker_binary_res_id",
                                        "STOKER_MODEL_BINARY",
                                    ),
                                )
                            ),
                        )
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseTagged(
                        release_to=rm_const.ReleaseStatus.stable,
                    )
                )
                return release_part

    class Notify(configs.ReferenceTaggedConfig.Notify):
        use_startrek = False
