from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.config_core.jg.cube import base as jg_cube
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import run_command as jg_run_command

from sandbox.projects.release_machine.components.configs.supportai import _constants as constants
from sandbox.projects.release_machine.components.configs.supportai import _utils as utils


def _get_build_env(env):
    if env == rm_const.ReleaseStatus.prestable:
        return rm_const.ReleaseStatus.stable

    return env


class BuildCubeInfo:
    def __init__(self, name, commands, resource_type, release_system):
        self.name = name
        self.commands = commands
        self.resource_type = resource_type
        self.release_system = release_system

    def get_jg_cube(self, env, version):
        out_folder_name = self.name
        cube_name = "{name}_resources".format(name=self.name)
        build_env = _get_build_env(env)

        return jg_run_command.RunCommand(
            name=utils.get_cube_name(constants.BUILD_STAGE, build_env, cube_name),
            task="common/misc/run_command",
            input=jg_cube.CubeInput(
                config={
                    "environment_variables": [
                        {"key": "YANDEX_ENVIRONMENT", "value": build_env},
                        {"key": "RELEASE_VERSION_STR", "value": version},
                        {"key": "PROJECT_PATH", "value": constants.PROJECT_PATH},
                        {"key": "WIDGET_CSP_HOSTS", "value": constants.WIDGET_CSP_HOSTS.get(env)},
                    ],
                    "arc_mount_config": {"enabled": True},
                    "cmd_line": "; ".join(command.format(out_folder_name=out_folder_name) for command in self.commands),
                    "result_resources": [
                        {
                            "path": out_folder_name,
                            "description": "Build resources of front",
                            "compression_type": "tar",
                            "type": self.resource_type,
                            "ci_badge": True,
                        }
                    ],
                },
            ),
            attributes={
                "requirements": {
                    "sandbox": {
                        "privileged": True,
                        "dns": "dns64",
                        "container_resource": constants.BUILD_SANDBOX_CONTAINER_ID,
                    },
                },
            },
        )

    def get_releasable_item(self):
        deploy_infos = [
            ri.SandboxInfo(stage=env)
            if self.release_system == rm_const.DeploySystem.sandbox.name
            else ri.YaDeployInfo(
                ri.DeployService(utils.get_deploy_stage_name(env)),
                stage=env,
            )
            for env in (rm_const.ReleaseStatus.testing, rm_const.ReleaseStatus.prestable, rm_const.ReleaseStatus.stable)
        ]

        return ri.ReleasableItem(
            name=self.resource_type.lower(),
            data=ri.SandboxResourceData(self.resource_type),
            deploy_infos=deploy_infos,
        )


def get_s3_cube(cube_name, tar_resource, version, env):
    build_env = _get_build_env(env)

    return jg_cube.Cube(
        name=utils.get_cube_name(constants.BUILD_STAGE, build_env, cube_name),
        task="projects/irt/upload_sb_resource_to_s3",
        input=jg_cube.CubeInput(
            tar_resource=tar_resource,
            prefix=version,
            s3_bucket="supportai-frontend-{env}".format(env=_get_build_env(env)),
            access_key_id="sec-01g5pbrn6cthykbm2egptf5aa6#access_key_id",
            access_secret_key="sec-01g5pbrn6cthykbm2egptf5aa6#access_secret_key",
        ),
        attributes={
            "requirements": {
                "sandbox": {
                    "tasks_resource": "3105306458",
                },
            },
        },
    )
