# -*- coding: utf-8 -*-


from sandbox.projects.release_machine.components import configs

from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets


class ReleaseToNannyCfg(configs.ReferenceCIConfig):
    name = "release_to_nanny"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="releasemachine"),
        login="ilyaturuntaev",
    )

    class JG(basic_build_presets.TaskletBuildPreset):
        # Uncomment line below if you want to link tasklet release commit to a particular ticket
        # release_ticket = "<SOME-TICKET>"
        pass

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "release_machine/tasklets/release_to_nanny"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "RELEASE_MACHINE"

        ya_make_abs_paths_glob = [
            "release_machine/tasklets/release_to_nanny/**",
        ]

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                configs.ri.ReleasableItem(
                    name="release_to_nanny",
                    data=configs.ri.SandboxResourceData("SANDBOX_TASKS_BINARY", ttl=14),
                    build_data=configs.ri.BuildData(
                        target="release_machine/tasklets/release_to_nanny",
                        artifact="release_machine/tasklets/release_to_nanny/release_to_nanny",
                    ),
                    deploy_infos=[
                        configs.ri.CiTaskletRegistryDeployInfo(
                            registry_paths=[
                                "common/releases/release_to_nanny",
                            ],
                        ),
                    ]
                ),
            ]

    class Notify(configs.ReferenceCIConfig.Notify):
        use_startrek = False
