# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.common import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class TunnellerCfg(configs.ReferenceTaggedConfig):
    name = "tunneller"
    responsible = "i024"

    class Releases(configs.ReferenceTaggedConfig.Releases):
        resources_info = [
            configs.ReleasedResourceInfo(
                name="tunneller",
                resource_type="TUNNELLER_BUNDLE",
                resource_name="tunneller_binary_res_id",
            ),
        ]

        allow_robots_to_release_stable = True
        release_followers_permanent = [
            "i024",
            "avitella",
        ]
        wait_for_deploy_time_sec = 600

    class Notify(configs.ReferenceTaggedConfig.Notify):
        use_startrek = False

        class Mail(configs.ReferenceTaggedConfig.Notify.Mail):
            mailing_list = ["search-components-releases"]

    class ChangelogCfg(configs.ReferenceTaggedConfig.ChangelogCfg):
        wiki_page = None
        review_groups = ["tunneller"]
        dirs = ["arcadia/search/tunneller"]

    class Testenv(configs.ReferenceTaggedConfig.Testenv):
        trunk_task_owner = "SEARCH-RELEASERS"

        class JobGraph(configs.ReferenceTaggedConfig.Testenv.JobGraph):
            @property
            def _tag_part(self):
                return [
                    jg_build.JobGraphElementYaMakeBuildTagged(
                        task_name="PATCH_PROFILES_MAKE_FILE",
                        job_params={
                            "job_name_parameter": "PATCH_MAKE_FILE",
                            "frequency": (jg_utils.TestFrequency.RUN_IF_DELAY_N_MINUTES, 10),
                            "test_type": jg_utils.TestType.CHECK_TEST,
                        },
                        filter_targets=[
                            "search/scraper/profile",
                            "search/scraper/master_profile"
                        ],
                    ),
                    jg_build.JobGraphElementYaMakeBuildTagged(
                        task_name="BUILD_TUNNELLER",
                        filter_targets=[
                            "search/tunneller",
                            "search/scraper/profile"
                        ],
                        job_arrows=(
                            jg_arrows.ParamsData(
                                input_key=sandbox_constants.ARCADIA_URL_KEY,
                                transform=lambda x, rm_config: "arcadia:/arc/trunk/arcadia@{}".format(x.revision),
                                override=True,
                            ),
                        ),
                        job_params={
                            "frequency": (jg_utils.TestFrequency.RUN_IF_DELAY_N_MINUTES, 5),
                            "test_type": jg_utils.TestType.CHECK_TEST,
                        },
                        ctx={
                            "use_arcadia": True,
                            "run_tests": True,
                            "run_long_tests": True,
                            "package_type": "tarball",
                            "resource_type": "TUNNELLER_BUNDLE",
                            "packages": "search/tunneller/deploy/package/package.json",
                        },
                        out={"TUNNELLER_BUNDLE": 30},
                    ),
                    jg_prerelease.JobGraphElementPreliminaryChangelogTagged(),
                ]

            @property
            def _release(self):
                default_release_part = super(self.__class__, self)._release
                release_part = [
                    jg_release.JobGraphElementNewTagTagged(),
                    jg_release.JobGraphElementReleaseTagged(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "tunneller_binary_res_id",
                                        "TUNNELLER_BUNDLE",
                                    )
                                )
                            ),
                            jg_arrows.ParamsData(
                                input_key="release_number",
                                transform=lambda x, rm_config: x.revision,
                                override=True,
                            )
                        )
                    ),
                    jg_release.JobGraphElementActionReleaseTagged(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_params={
                            "frequency": (jg_utils.TestFrequency.RUN_IF_DELAY_N_MINUTES, 60),
                            "filter_targets": [
                                "search/scraper/profile",
                                "search/scraper/master_profile"
                            ],
                        },
                    ),
                ]
                return default_release_part + release_part

    def __init__(self):
        super(TunnellerCfg, self).__init__()
        self.changelog_cfg = self.ChangelogCfg(self, self.svn_cfg.main_url, self.responsible)
