# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components.config_core import notifications as rm_notifications
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.presets as jg_presets
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class TurboDDMCfg(configs.ReferenceBranchedConfig):
    name = "turbo_ddm"
    responsible = "shubert"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_db = "turbo-ddm-trunk"
        trunk_task_owner = "TURBO"
        branch_db_template = "turbo-ddm-{testenv_db_num}"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            _preset = jg_presets.SinglePackagePreset(
                build_task_name="BUILD_TURBO",
                build_ctx={"checkout_mode": "auto"},
                package_names="packages/debian/runtime/web/turbopages/dynamic_data_miner/pkg.json",
                deploy_system=rm_const.DeploySystem.nanny.name,
                stages=[jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable)],
            )

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="turbo_ddm_binary",
                    data=ri.SandboxResourceData("TURBO_DDM_PACKAGE", ttl=30),
                    deploy_infos=[
                        ri.NannyDeployInfo(ri.DeployService("turbo_dynamic_data_miner_other_production_yp_vla")),
                    ],
                )
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceBranchedConfig.Notify):

        notifications = [
            rm_notifications.Notification(
                event_type="ReleaseDeployed",
                chat_name="turbo_devops",
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_deployed_oldschool.html",
            ),
            rm_notifications.Notification(
                event_type="ReleaseCreated",
                chat_name="turbo_devops",
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_created_oldschool.html",
            ),
        ]

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            """Telegram notifications configuration"""
            chats = ["turbo_devops"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "shubert"
            queue = "TURBODDMREL"
            dev_queue = "TURBO"
            summary_template = u"priemka turbo_ddm {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "shubert",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "jandekspoisk/kachestvopoiska/turbopages/dev/releases/ddm/"
        dirs = [
            "arcadia/quality/functionality/turbo/media_mass_api_walker/",
        ]
        review_groups = [
            "shubert",
        ]
