# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components.config_core import notifications as rm_notifications
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.presets as jg_presets
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class TurboMergerCfg(configs.ReferenceBranchedConfig):
    name = "turbo_merger"
    responsible = "shubert"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_db = "turbo-merger-trunk"
        trunk_task_owner = "TURBO"
        branch_db_template = "turbo-merger-{testenv_db_num}"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            _preset = jg_presets.SinglePackagePreset(
                build_task_name="BUILD_TURBO",
                build_ctx={"checkout_mode": "auto"},
                package_names="packages/debian/runtime/web/turbopages/merger/pkg.json",
                deploy_system=rm_const.DeploySystem.nanny.name,
                stages=[jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable)],
            )

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="turbo_merger_binary",
                    data=ri.SandboxResourceData("TURBO_MERGER_PACKAGE", ttl=30),
                    deploy_infos=[ri.single_nanny_service("turbo_merger_production_yp_vla")],
                )
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceBranchedConfig.Notify):

        notifications = [
            rm_notifications.Notification(
                event_type="ReleaseDeployed",
                chat_name="turbo_devops",
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_deployed_oldschool.html",
            ),
            rm_notifications.Notification(
                event_type="ReleaseCreated",
                chat_name="turbo_devops",
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_created_oldschool.html",
            ),
        ]

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["turbo_devops"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "shubert"
            queue = "TURBOMERGERREL"
            dev_queue = "TURBO"
            summary_template = u"priemka turbo_merger {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "shubert",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "jandekspoisk/kachestvopoiska/turbopages/dev/releases/turbo_merger/"
        observed_paths = [
            "arcadia/quality/functionality/turbo/merger/",
        ]
        review_groups = [
            "shubert",
        ]
